/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.util.ArrayList;
import java.util.List;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.Declaration;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Generifiable;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;

abstract class AbstractGenerifiable
implements Generifiable,
Declaration {
    private List<TypeVariable> typeVariables = null;

    AbstractGenerifiable() {
    }

    protected abstract CodeModel owner();

    @Override
    public void declare(Formatter f) {
        if (this.typeVariables != null) {
            f.p('<');
            for (int i = 0; i < this.typeVariables.size(); ++i) {
                if (i != 0) {
                    f.p(',');
                }
                f.d(this.typeVariables.get(i));
            }
            f.p('>');
        }
    }

    @Override
    public TypeVariable generify(String name) {
        TypeVariable v = new TypeVariable(this.owner(), name);
        if (this.typeVariables == null) {
            this.typeVariables = new ArrayList<TypeVariable>(3);
        }
        this.typeVariables.add(v);
        return v;
    }

    @Override
    public TypeVariable generify(String name, Class<?> bound) {
        return this.generify(name, this.owner().ref(bound));
    }

    @Override
    public TypeVariable generify(String name, TypeReference bound) {
        return this.generify(name).bound(bound);
    }

    @Override
    public TypeVariable[] typeParams() {
        if (this.typeVariables == null) {
            return TypeVariable.EMPTY_ARRAY;
        }
        return this.typeVariables.toArray(new TypeVariable[this.typeVariables.size()]);
    }
}

