/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.internal.dsql;

import java.util.Calendar;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.el.datetime.DateTime;
import org.mule.util.TemplateParser;

public class DsqlMelParserUtils {
    private TemplateParser parser = TemplateParser.createMuleStyleParser();

    public Object parseDsql(MuleContext muleContext, MuleEvent event, Object query) {
        if (!(query instanceof String)) {
            return query;
        }
        String stringQuery = (String)query;
        TemplateParser.PatternInfo style = TemplateParser.createMuleStyleParser().getStyle();
        ExpressionManager expressionManager = muleContext.getExpressionManager();
        if (stringQuery.startsWith(style.getPrefix()) && stringQuery.endsWith(style.getSuffix())) {
            return expressionManager.evaluate(stringQuery, event);
        }
        return this.parse(expressionManager, event, stringQuery);
    }

    private Object parse(final ExpressionManager expressionManager, final MuleEvent event, String source) {
        return this.parser.parse(new TemplateParser.TemplateCallback(){

            public Object match(String token) {
                Object result = expressionManager.evaluate(token, event, false);
                if (result instanceof Calendar) {
                    return new DateTime((Calendar)result).toString();
                }
                if (result instanceof Date) {
                    return new DateTime((Date)result).toString();
                }
                if (result instanceof XMLGregorianCalendar) {
                    return new DateTime((XMLGregorianCalendar)result).toString();
                }
                if (result instanceof MuleMessage) {
                    return ((MuleMessage)result).getPayload();
                }
                return result;
            }
        }, source);
    }
}

