/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.internal.source;

import java.util.Map;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.callback.SourceCallback;
import org.mule.security.oauth.processor.AbstractListeningMessageProcessor;

public class ErrorAwareSourceCallback
implements SourceCallback {
    private AbstractListeningMessageProcessor delegate;

    public ErrorAwareSourceCallback(AbstractListeningMessageProcessor delegate) {
        this.delegate = delegate;
    }

    public Object process() throws Exception {
        try {
            return this.delegate.process();
        }
        catch (MessagingException e) {
            return this.processMessagingException(e).getMessage().getPayload();
        }
    }

    public Object process(Object o) throws Exception {
        try {
            return this.delegate.process(o);
        }
        catch (MessagingException e) {
            return this.processMessagingException(e).getMessage().getPayload();
        }
    }

    public Object process(Object o, Map<String, Object> map) throws Exception {
        try {
            return this.delegate.process(o, map);
        }
        catch (MessagingException e) {
            return this.processMessagingException(e).getMessage().getPayload();
        }
    }

    public MuleEvent processEvent(MuleEvent muleEvent) throws MuleException {
        try {
            return this.delegate.process(muleEvent);
        }
        catch (MessagingException e) {
            return this.processMessagingException(e);
        }
    }

    private MuleEvent processMessagingException(MessagingException e) throws MessagingException {
        MuleEvent muleEvent = this.delegate.getFlowConstruct().getExceptionListener().handleException((Exception)((Object)e), e.getEvent());
        if (muleEvent.getMessage().getExceptionPayload() == null) {
            return muleEvent;
        }
        throw e;
    }
}

