/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.ws.model.cache;

public class WSConsumerConfigKey {

    private String wsdlId;
    private String serviceAddress;
    private String service;
    private String port;

    public WSConsumerConfigKey(String wsdlId, String serviceAddress, String service, String port) {
        this.wsdlId = wsdlId;
        this.serviceAddress = serviceAddress;
        this.service = service;
        this.port = port;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (!(o instanceof WSConsumerConfigKey))
            return false;

        WSConsumerConfigKey that = (WSConsumerConfigKey) o;

        if (port != null ? !port.equals(that.port) : that.port != null)
            return false;
        if (service != null ? !service.equals(that.service) : that.service != null)
            return false;
        if (serviceAddress != null ? !serviceAddress.equals(that.serviceAddress) : that.serviceAddress != null)
            return false;
        if (wsdlId != null ? !wsdlId.equals(that.wsdlId) : that.wsdlId != null)
            return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = wsdlId != null ? wsdlId.hashCode() : 0;
        result = 31 * result + (serviceAddress != null ? serviceAddress.hashCode() : 0);
        result = 31 * result + (service != null ? service.hashCode() : 0);
        result = 31 * result + (port != null ? port.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append("WSDL id: ").append(wsdlId).append(", Service Address: ").append(serviceAddress).append(", Service: ").append(service)
                .append(", Port: ").append(port);
        return sb.toString();
    }

    public String getWsdlId() {
        return wsdlId;
    }

    public String getServiceAddress() {
        return serviceAddress;
    }

    public String getService() {
        return service;
    }

    public String getPort() {
        return port;
    }
}
