/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.ws.model;

import com.google.common.base.Optional;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.config.ConfigurationException;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.PropertyScope;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.devkit.api.ws.definition.ServiceDefinition;
import org.mule.devkit.internal.ws.common.EnhancedServiceDefinition;
import org.mule.devkit.internal.ws.common.WsdlAdapter;
import org.mule.devkit.internal.ws.common.WsdlSplitKey;
import org.mule.devkit.internal.ws.metadata.WsdlMetaDataDescriptor;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.module.ws.consumer.WSConsumer;
import org.mule.security.oauth.callback.ProcessCallback;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.SimpleDataType;
import org.w3c.dom.Document;

import java.util.List;

public class InvokeSoapMessageProcessor extends DevkitBasedMessageProcessor implements MessageProcessor, OperationMetaDataEnabled {

    protected Object type;

    public InvokeSoapMessageProcessor(String operationName) {
        super(operationName);
    }

    public MuleEvent doProcess(final MuleEvent event) throws Exception {
        WsdlAdapter moduleObject = (WsdlAdapter) findOrCreate(null, false, event);
        final String _transformedType = ((String) evaluateAndTransform(getMuleContext(), event, String.class, null, type));
        final ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object>) moduleObject).getProcessTemplate();
        final List<Class<? extends Exception>> managedExceptions = moduleObject.managedExceptions();

        Object resultPayload = processTemplate.execute(new ProcessCallback<Object, Object>() {

            public List<Class<? extends Exception>> getManagedExceptions() {
                return managedExceptions;
            }

            public boolean isProtected() {
                return false;
            }

            public Object process(Object object) throws Exception {

                WsdlAdapter wsdlAdapter = (WsdlAdapter) object;
                WsdlSplitKey splitKey = new WsdlSplitKey(_transformedType, wsdlAdapter);

                ServiceDefinition serviceDefinition = wsdlAdapter.wsResolver().serviceDefinition(splitKey.id());

                Optional<List<Document>> headers = wsdlAdapter.headers(wsdlAdapter.wsResolver().serviceDefinition(splitKey.id()), splitKey.operation());
                if (headers.isPresent()) {
                    addHeadersToMessage(headers.get(), event.getMessage());
                }
                wsdlAdapter.headers(serviceDefinition, splitKey.operation());


                Optional<? extends SoapBodyEnricher> bodyEnricher = wsdlAdapter.bodyEnricher();
                if (bodyEnricher.isPresent()){
                    Transformer payloadTransformer = muleContext.getRegistry().lookupTransformer(DataTypeFactory.createFromObject(event.getMessage().getPayload()), new SimpleDataType<Object>(Document.class));
                    Object modifiedBody = bodyEnricher.get().process(serviceDefinition, splitKey.operation(), (Document) payloadTransformer.transform(event.getMessage().getPayload()));
                    event.getMessage().setPayload(modifiedBody);
                }

                EnhancedServiceDefinition enhancedServiceDefinition = wsdlAdapter.wsResolver().enhancedServiceDefinition(splitKey.id(), wsdlAdapter, splitKey.operation());
                WSConsumer wsConsumer = wsdlAdapter.wsResolver().wsConsumer(enhancedServiceDefinition, muleContext);
                try {
                    return wsConsumer.process(event);
                } catch (Exception e) {
                    wsdlAdapter.handleException(e);
                    throw e;
                }
            }

            private void addHeadersToMessage(List<Document> headers, MuleMessage message) {
                int headerIndx = 0;
                for (Document header : headers) {
                    message.setProperty(WsdlMetaDataDescriptor.SOAP_PREFIX + "soapconnect.header." + headerIndx, header, PropertyScope.OUTBOUND);
                    headerIndx++;
                }
            }

        }, this, event);
        return ((MuleEvent) resultPayload);

    }

    @Override
    public Result<MetaData> getInputMetaData() {
        return getMetaDataResult(TypeDescribingProperty.TypeScope.INPUT);
    }

    @Override
    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        return getMetaDataResult(TypeDescribingProperty.TypeScope.OUTPUT);
    }

    private Result<MetaData> getMetaDataResult(TypeDescribingProperty.TypeScope scope) {
        if (((type) == null) || ((type).toString() == null)) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), "There was an error retrieving metadata from parameter [type] at processor invoke at connector");
        }
        DefaultMetaDataKey metaDataKey = new DefaultMetaDataKey((type).toString(), null);
        metaDataKey.addProperty(new TypeDescribingProperty(scope, "invoke"));
        Result<MetaData> genericMetaData = getGenericMetaData(metaDataKey);

        return genericMetaData;
    }

    public Result<MetaData> getGenericMetaData(MetaDataKey metaDataKey) {

        try {
            WsdlMetaDataDescriptor invokeMessageProcessorMetaDataDescriptor = new WsdlMetaDataDescriptor();
            WsdlAdapter moduleObject = (WsdlAdapter) findOrCreate(null, false, null);
            try {
                Result<MetaData> metadata = invokeMessageProcessorMetaDataDescriptor.getMetaData(metaDataKey, moduleObject);
                if ((Result.Status.FAILURE).equals(metadata.getStatus())) {
                    return metadata;
                }
                if (metadata.get() == null) {
                    return new DefaultResult<MetaData>(null, (Result.Status.FAILURE),
                            "There was an error processing metadata at WsdlConnector at invoke retrieving was successful but result is null");
                }
                return metadata;
            } catch (Exception e) {
                return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), e.getMessage(), FailureType.UNSPECIFIED, e);
            }
        } catch (ClassCastException cast) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE),
                    "There was an error getting metadata, there was no connection manager available. Maybe you're trying to use metadata from an Oauth connector");
        } catch (ConfigurationException e) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), e.getMessage(), FailureType.UNSPECIFIED, e);
        } catch (RegistrationException e) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), e.getMessage(), FailureType.UNSPECIFIED, e);
        } catch (IllegalAccessException e) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), e.getMessage(), FailureType.UNSPECIFIED, e);
        } catch (InstantiationException e) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), e.getMessage(), FailureType.UNSPECIFIED, e);
        } catch (Exception e) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), e.getMessage(), FailureType.UNSPECIFIED, e);
        }
    }

    public void setType(Object value) {
        this.type = value;
    }
}
