/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.ws.common;

import com.google.common.base.Optional;
import org.mule.devkit.api.ws.authentication.WsdlSecurityStrategy;
import org.mule.devkit.api.ws.transport.WsdlTransport;

import java.net.URL;
import java.util.Collections;
import java.util.List;

public class DefaultEnhancedServiceDefinition implements EnhancedServiceDefinition {

    List<WsdlSecurityStrategy> strategies;
    private String id;
    private URL wsdlUrl;
    private String service;
    private String port;
    private String serviceAddress;
    private Optional<WsdlTransport> transport;
    private String operation;

    public DefaultEnhancedServiceDefinition(String id, URL wsdlUrl, String service, String port, String serviceAddress, List<WsdlSecurityStrategy> strategies,
            WsdlTransport transport, String operation) {
        this.id = id;
        this.wsdlUrl = wsdlUrl;
        this.service = service;
        this.port = port;
        this.serviceAddress = serviceAddress;
        this.strategies = strategies == null ? Collections.EMPTY_LIST : strategies;
        this.transport = Optional.fromNullable(transport);
        this.operation = operation;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public URL getWsdlUrl() {
        return wsdlUrl;
    }

    @Override
    public String getService() {
        return service;
    }

    @Override
    public String getPort() {
        return port;
    }

    @Override
    public String getServiceAddress() {
        return serviceAddress;
    }

    @Override
    public List<WsdlSecurityStrategy> getStrategies() {
        return strategies;
    }

    @Override
    public Optional<WsdlTransport> getTransport() {
        return transport;
    }

    @Override
    public String getOperation() {
        return operation;
    }
}
