/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.metadata.cache;

import org.mule.common.Result;
import org.mule.devkit.api.metadata.ConnectorMetaDataCache;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

/**
 * @author MuleSoft, Inc
 */
public interface PersistentMetaDataCache extends ConnectorMetaDataCache {

    Result.Status save(File persistentCache, boolean overwrite);

    Result.Status load(File persistentCache) throws IOException, ClassNotFoundException;

    Path getLocation();

}
