/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor.globalcloudconnector;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.VariableComparator;
import org.mule.devkit.generation.studio.editor.globalcloudconnector.GlobalCloudConnectorTypeBuilder;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.HttpBasicAuthComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.GlobalType;

public class GlobalCloudConnectorHttpBasicAuthBuilder
extends GlobalCloudConnectorTypeBuilder {
    private HttpBasicAuthComponent httpBasicAuthComponent;

    public GlobalCloudConnectorHttpBasicAuthBuilder(Context context, Module module, HttpBasicAuthComponent httpBasicAuthComponent, boolean abstrac7, String globalRefId) {
        super(context, module, abstrac7, globalRefId);
        this.httpBasicAuthComponent = httpBasicAuthComponent;
    }

    @Override
    protected void buildConnectivityTestingAttr(GlobalType globalCloudConnector) {
        this.setConnectivityTestingAttribute(globalCloudConnector, (Optional<Method>)this.httpBasicAuthComponent.testConnectivityMethod());
    }

    @Override
    protected List<Field> getConfigurableFieldsSorted() {
        List configurableFields = this.module.getConfigurableFields();
        Collections.sort(configurableFields, new VariableComparator());
        return configurableFields;
    }

    @Override
    protected boolean hasConnectionMethod() {
        return false;
    }

    @Override
    protected ConnectMethod connectMethod() {
        return null;
    }

    @Override
    protected String getDescriptionBasedOnType() {
        String javaDocSummary = "Global " + this.httpBasicAuthComponent.friendlyName() + " configuration information.";
        javaDocSummary = javaDocSummary + (this.httpBasicAuthComponent.getJavaDocSummary() != null ? " " + this.httpBasicAuthComponent.getJavaDocSummary() : "");
        return this.helper.formatDescription(javaDocSummary);
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return this.httpBasicAuthComponent.configElementName();
    }

    @Override
    protected String getCaptionBasedOnType() {
        return this.helper.getFormattedCaption(this.module).concat(": ").concat(this.httpBasicAuthComponent.friendlyName());
    }

    @Override
    protected List<AttributeType> getConnectionAttributes() {
        ArrayList<Field> configurableFields = new ArrayList<Field>();
        configurableFields.add(this.httpBasicAuthComponent.username());
        if (this.httpBasicAuthComponent.password().isPresent()) {
            configurableFields.add((Field)this.httpBasicAuthComponent.password().get());
        }
        return this.getConnectionAttributes(configurableFields);
    }
}

