/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.BaseStudioXmlBuilder;
import org.mule.devkit.generation.studio.editor.ComplexTypeParameterVisitor;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.AbstractElementType;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.Booleantype;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.NestedElementReference;
import org.mule.devkit.model.studio.NestedElementType;
import org.mule.devkit.model.studio.StudioModel;
import org.mule.devkit.model.visitor.ModelVisitor;
import org.mule.devkit.utils.NameUtils;

public class NestedsBuilder
extends BaseStudioXmlBuilder
implements StudioModel.Builder<List<JAXBElement<? extends AbstractElementType>>> {
    public NestedsBuilder(Context ctx, Module module) {
        super(ctx, module);
    }

    public List<JAXBElement<? extends AbstractElementType>> build() {
        ArrayList<JAXBElement<? extends AbstractElementType>> nesteds = new ArrayList<JAXBElement<? extends AbstractElementType>>();
        ComplexTypeParameterVisitor complexTypeParameterVisitor = new ComplexTypeParameterVisitor();
        this.module.accept((ModelVisitor)complexTypeParameterVisitor);
        for (Variable complexTypeParameter : complexTypeParameterVisitor.getRegisteredComplexTypes()) {
            if (complexTypeParameter.isRefOnly()) continue;
            if (complexTypeParameter.isArrayOrListOfComplexType(false)) {
                nesteds.add((JAXBElement<? extends AbstractElementType>)this.objectFactory.createNested(this.generateNestedForArrayOrListOfComplexType(complexTypeParameter)));
                nesteds.add((JAXBElement<? extends AbstractElementType>)this.objectFactory.createNested(this.generateNestedForArrayOrListOfComplexGenericType(complexTypeParameter)));
                continue;
            }
            nesteds.add((JAXBElement<? extends AbstractElementType>)this.objectFactory.createNested(this.generateNestedForType(complexTypeParameter)));
        }
        return nesteds;
    }

    private Type getGenericType(Variable identifiable) {
        Type genericType;
        List variableTypeParameters = identifiable.getTypeArguments();
        if (variableTypeParameters.size() != 0 && variableTypeParameters.get(0) != null && (genericType = (Type)variableTypeParameters.get(0)).isComplexTypeWithGetterAndSetter(true)) {
            return genericType;
        }
        return null;
    }

    private NestedElementType generateNestedForArrayOrListOfComplexGenericType(Variable<?> variable) {
        NestedElementType nestedElementType = new NestedElementType();
        String genericTypeName = NameUtils.singularize((String)variable.getName());
        nestedElementType.setLocalId(NameUtils.uncamel((String)genericTypeName));
        nestedElementType.setAbstract(Boolean.valueOf(false));
        nestedElementType.setCaption(NameUtils.friendlyNameFromCamelCase((String)genericTypeName));
        nestedElementType.setDescription("");
        nestedElementType.setXmlname(NameUtils.uncamel((String)genericTypeName));
        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption(this.helper.formatCaption(NameUtils.friendlyNameFromCamelCase((String)genericTypeName)));
        attributeCategory.setDescription(this.helper.formatDescription(variable.getJavaDocSummary()));
        Group group = new Group();
        group.setCaption(this.helper.formatCaption(NameUtils.friendlyNameFromCamelCase((String)genericTypeName)));
        group.setId("genericType" + NameUtils.camel((String)genericTypeName) + "Group");
        attributeCategory.getGroup().add(group);
        Type genericType = this.getGenericType(variable);
        if (genericType != null) {
            for (Field field : genericType.getFields()) {
                JAXBElement<? extends AttributeType> jaxbElement;
                if (!field.hasGetter() || !field.hasSetter() || field.shouldBeIgnored() || (jaxbElement = this.createJaxbElement((Variable<?>)field)) == null) continue;
                ((AttributeType)jaxbElement.getValue()).setRequired(Boolean.valueOf(false));
                group.getRegexpOrEncodingOrModeSwitch().add(jaxbElement);
            }
        }
        nestedElementType.getRegexpOrEncodingOrString().add(this.objectFactory.createAttributeCategory(attributeCategory));
        return nestedElementType;
    }

    private NestedElementType generateNestedForArrayOrListOfComplexType(Variable<?> variable) {
        NestedElementType nestedElementType = new NestedElementType();
        nestedElementType.setLocalId(NameUtils.uncamel((String)variable.getName()));
        nestedElementType.setAbstract(Boolean.valueOf(false));
        nestedElementType.setCaption(NameUtils.friendlyNameFromCamelCase((String)variable.getName()));
        nestedElementType.setDescription("");
        nestedElementType.setXmlname(NameUtils.uncamel((String)variable.getName()));
        NestedElementReference childElement = new NestedElementReference();
        String defaultValue = variable.getDefaultValue();
        if (defaultValue != null) {
            childElement.setDefaultValue(defaultValue);
        }
        childElement.setName("http://www.mulesoft.org/schema/mule/" + this.moduleName + '/' + NameUtils.uncamel((String)NameUtils.singularize((String)variable.getName())));
        childElement.setCaption(this.helper.getFormattedCaption(variable));
        childElement.setAllowMultiple(Boolean.valueOf(true));
        childElement.setPositional(Boolean.valueOf(true));
        childElement.setInplace(Boolean.valueOf(true));
        childElement.setJavaType(variable.getJavaType());
        childElement.setRequired(Boolean.valueOf(!variable.isOptional()));
        Group group = new Group();
        group.setId(variable.getName() + "ListGroup");
        group.setCaption(this.helper.formatCaption(NameUtils.friendlyNameFromCamelCase((String)variable.getName())));
        group.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupChildElement(childElement));
        nestedElementType.getRegexpOrEncodingOrString().add(this.objectFactory.createGroup(group));
        return nestedElementType;
    }

    private NestedElementType generateNestedForType(Variable<?> variable) {
        NestedElementType nestedElementType = new NestedElementType();
        nestedElementType.setLocalId(NameUtils.uncamel((String)variable.getName()));
        nestedElementType.setAbstract(Boolean.valueOf(false));
        nestedElementType.setCaption("");
        nestedElementType.setDescription("");
        nestedElementType.setXmlname(NameUtils.uncamel((String)variable.getName()));
        Booleantype refBoolean = new Booleantype();
        refBoolean.setDescription("Provide a reference to a bean or use an expression");
        refBoolean.setCaption("Reference or expression");
        refBoolean.setName("useReference");
        refBoolean.setFillLine(Boolean.valueOf(true));
        nestedElementType.getRegexpOrEncodingOrString().add(this.objectFactory.createGroupRadioBoolean(refBoolean));
        AttributeType stringAttributeType = this.generateRefAttribute(variable);
        stringAttributeType.setControlled("useReference");
        nestedElementType.getRegexpOrEncodingOrString().add(this.objectFactory.createNestedElementTypeString(stringAttributeType));
        Booleantype radio2 = new Booleantype();
        radio2.setDescription("Define this element's attributes");
        radio2.setCaption("Define attributes");
        radio2.setName("complex");
        radio2.setFillLine(Boolean.valueOf(true));
        nestedElementType.getRegexpOrEncodingOrString().add(this.objectFactory.createGroupRadioBoolean(radio2));
        for (Field<Type> field : this.getAllFields(variable.asType())) {
            JAXBElement<? extends AttributeType> jaxbElement;
            if (!field.hasGetter() || !field.hasSetter() || field.shouldBeIgnored() || (jaxbElement = this.createJaxbElement((Variable<?>)field)) == null) continue;
            ((AttributeType)jaxbElement.getValue()).setRequired(Boolean.valueOf(false));
            ((AttributeType)jaxbElement.getValue()).setControlled("complex");
            nestedElementType.getRegexpOrEncodingOrString().add(jaxbElement);
        }
        return nestedElementType;
    }

    private List<Field<Type>> getAllFields(Type type) {
        if (!type.hasSuperClass()) {
            return type.getFields();
        }
        LinkedList<Field<Type>> fields = new LinkedList<Field<Type>>();
        fields.addAll(this.getAllFields(type.getSuperClass()));
        fields.addAll(type.getFields());
        return fields;
    }

    private AttributeType generateRefAttribute(Variable<?> variable) {
        AttributeType stringAttributeType = new AttributeType();
        stringAttributeType.setName("ref");
        stringAttributeType.setCaption(this.helper.getFormattedCaption(variable));
        stringAttributeType.setDescription("");
        return stringAttributeType;
    }
}

