/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.IOUtil;
import org.mule.devkit.maven.AbstractMuleMojo;

@Mojo(name="install", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class InstallMojo
extends AbstractMuleMojo {
    @Parameter(alias="copyToAppsDirectory", property="copyToAppsDirectory", defaultValue="false", required=true)
    protected boolean copyToAppsDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String packaging = this.project.getPackaging();
        if (this.copyToAppsDirectory) {
            if (!"mule".equals(packaging)) {
                throw new MojoExecutionException(String.format("Only 'mule' packaging supports 'copyToAppsDirectory' configuration element, current project's packaging is '%s'", packaging));
            }
            File muleHome = this.determineMuleHome();
            if (muleHome != null) {
                this.copyMuleZipToMuleHome(muleHome);
            } else {
                this.getLog().warn((CharSequence)("MULE_HOME is not set, not copying " + this.finalName + ".zip"));
            }
        }
    }

    private File determineMuleHome() throws MojoExecutionException {
        File muleHomeFile = null;
        String muleHome = this.getMuleHomeEnvVarOrSystemProperty();
        if (muleHome != null) {
            muleHomeFile = new File(muleHome);
            if (!muleHomeFile.exists()) {
                String message = String.format("MULE_HOME is set to %1s but this directory does not exist.", muleHome);
                throw new MojoExecutionException(message);
            }
            if (!muleHomeFile.canWrite()) {
                String message = String.format("MULE_HOME is set to %1s but the directory is not writeable.", muleHome);
                throw new MojoExecutionException(message);
            }
        }
        return muleHomeFile;
    }

    private String getMuleHomeEnvVarOrSystemProperty() {
        String muleHome = System.getenv("MULE_HOME");
        if (muleHome == null) {
            muleHome = System.getProperty("mule.home");
        }
        return muleHome;
    }

    private void copyMuleZipToMuleHome(File muleHome) throws MojoExecutionException {
        try {
            this.copyMuleZipFileToTempFileInAppsDirectory(muleHome);
            this.renameMuleZipFileToFinalName(muleHome);
        }
        catch (IOException iox) {
            throw new MojoExecutionException("Exception while copying to apps directory", (Exception)iox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyMuleZipFileToTempFileInAppsDirectory(File muleHome) throws IOException {
        FileInputStream muleZipInput = null;
        FileOutputStream tempOutput = null;
        try {
            File zipFile = this.getMuleZipFile();
            muleZipInput = new FileInputStream(zipFile);
            File tempFile = this.tempFileInAppsDirectory(muleHome);
            tempOutput = new FileOutputStream(tempFile);
            IOUtil.copy((InputStream)muleZipInput, (OutputStream)tempOutput);
            String message = String.format("Copying %1s to %2s", zipFile.getAbsolutePath(), tempFile.getAbsolutePath());
            this.getLog().info((CharSequence)message);
        }
        catch (Throwable throwable) {
            IOUtil.close(muleZipInput);
            IOUtil.close(tempOutput);
            throw throwable;
        }
        IOUtil.close((InputStream)muleZipInput);
        IOUtil.close((OutputStream)tempOutput);
    }

    private void renameMuleZipFileToFinalName(File muleHome) throws MojoExecutionException {
        File appsDirectory;
        File targetFile;
        File sourceFile = this.tempFileInAppsDirectory(muleHome);
        if (!sourceFile.renameTo(targetFile = new File(appsDirectory = this.muleAppsDirectory(muleHome), this.finalName + ".zip"))) {
            String message = String.format("Could not rename %1s to %2s", sourceFile.getAbsolutePath(), targetFile.getAbsolutePath());
            throw new MojoExecutionException(message);
        }
        String message = String.format("Renaming %1s to %2s", sourceFile.getAbsolutePath(), targetFile.getAbsolutePath());
        this.getLog().info((CharSequence)message);
    }

    private File tempFileInAppsDirectory(File muleHome) {
        File appsDirectory = this.muleAppsDirectory(muleHome);
        return new File(appsDirectory, this.finalName + ".temp");
    }

    private File muleAppsDirectory(File muleHome) {
        return new File(muleHome, "apps");
    }
}

