/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.mule.devkit.model.code.AbstractExpression;
import org.mule.devkit.model.code.Annotable;
import org.mule.devkit.model.code.AnnotationStringValue;
import org.mule.devkit.model.code.AnnotationValue;
import org.mule.devkit.model.code.AnnotationWriter;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.EnumConstant;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.GeneratedAnnotationUse;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypedAnnotationWriter;

public final class AnnotationArrayMember
extends AnnotationValue
implements Annotable {
    private final List<AnnotationValue> values = new ArrayList<AnnotationValue>();
    private final CodeModel owner;

    AnnotationArrayMember(CodeModel owner) {
        this.owner = owner;
    }

    public AnnotationArrayMember param(String value) {
        AnnotationStringValue annotationValue = new AnnotationStringValue(ExpressionFactory.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public AnnotationArrayMember param(boolean value) {
        AnnotationStringValue annotationValue = new AnnotationStringValue(ExpressionFactory.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public AnnotationArrayMember param(byte value) {
        AnnotationStringValue annotationValue = new AnnotationStringValue(ExpressionFactory.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public AnnotationArrayMember param(char value) {
        AnnotationStringValue annotationValue = new AnnotationStringValue(ExpressionFactory.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public AnnotationArrayMember param(double value) {
        AnnotationStringValue annotationValue = new AnnotationStringValue(ExpressionFactory.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public AnnotationArrayMember param(long value) {
        AnnotationStringValue annotationValue = new AnnotationStringValue(ExpressionFactory.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public AnnotationArrayMember param(short value) {
        AnnotationStringValue annotationValue = new AnnotationStringValue(ExpressionFactory.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public AnnotationArrayMember param(int value) {
        AnnotationStringValue annotationValue = new AnnotationStringValue(ExpressionFactory.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public AnnotationArrayMember param(float value) {
        AnnotationStringValue annotationValue = new AnnotationStringValue(ExpressionFactory.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public AnnotationArrayMember param(final Enum<?> value) {
        AnnotationValue annotationValue = new AnnotationValue(){

            @Override
            public void generate(Formatter f) {
                f.t(AnnotationArrayMember.this.owner.ref(value.getDeclaringClass())).p('.').p(value.name());
            }
        };
        this.values.add(annotationValue);
        return this;
    }

    public AnnotationArrayMember param(EnumConstant value) {
        AnnotationStringValue annotationValue = new AnnotationStringValue(value);
        this.values.add(annotationValue);
        return this;
    }

    public AnnotationArrayMember param(GeneratedExpression value) {
        AnnotationStringValue annotationValue = new AnnotationStringValue(value);
        this.values.add(annotationValue);
        return this;
    }

    public AnnotationArrayMember param(final Class<?> value) {
        AnnotationStringValue annotationValue = new AnnotationStringValue(new AbstractExpression(){

            @Override
            public void generate(Formatter f) {
                f.p(value.getName().replace('$', '.'));
                f.p(".class");
            }
        });
        this.values.add(annotationValue);
        return this;
    }

    public AnnotationArrayMember param(Type type) {
        TypeReference clazz = type.boxify();
        AnnotationStringValue annotationValue = new AnnotationStringValue(clazz.dotclass());
        this.values.add(annotationValue);
        return this;
    }

    @Override
    public GeneratedAnnotationUse annotate(Class<? extends Annotation> clazz) {
        return this.annotate(this.owner.ref(clazz));
    }

    @Override
    public GeneratedAnnotationUse annotate(TypeReference clazz) {
        GeneratedAnnotationUse a = new GeneratedAnnotationUse(clazz);
        this.values.add(a);
        return a;
    }

    @Override
    public <W extends AnnotationWriter> W annotate2(Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    @Override
    public Collection<GeneratedAnnotationUse> annotations() {
        return Collections.unmodifiableList(this.values);
    }

    public AnnotationArrayMember param(GeneratedAnnotationUse value) {
        this.values.add(value);
        return this;
    }

    @Override
    public void generate(Formatter f) {
        f.p('{').nl().i();
        boolean first = true;
        for (AnnotationValue aValue : this.values) {
            if (!first) {
                f.p(',').nl();
            }
            f.g(aValue);
            first = false;
        }
        f.nl().o().p('}');
    }
}

