/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */


package org.mule.api.annotations.rest;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Allows you to insert custom headers in the HTTP request. When using this annotation, you must specify the name of the header to include in the call.
 * As with the {@link RestUriParam} annotation, you can apply this annotation to {@link org.mule.api.annotations.Processor}
 * methods arguments or to connector fields marked {@link org.mule.api.annotations.Configurable}
 */
@Target(value = {ElementType.PARAMETER, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Deprecated
public @interface RestHeaderParam {
    String value();

    String separatedBy() default "";

    boolean ignoreIfEmpty() default false;
}
