/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations.components;


import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Marks the class annotated as an @{@link org.mule.api.annotations.lifecycle.OnException} handler component
 * The constraints for @Handler class are:
 *
 * The constrains for {@link Handler} classes are:
 * <ol>
 * <li>Must be public
 * <li>Must be annotated with {@link Handler}
 * <li>Must have an empty constructor
 * <li>Might have an @Inject parameter with the sam type of the connector
 * <li>Must have an method annotated with {@link org.mule.api.annotations.Handle}
 * </ol>
 *
 * @see org.mule.api.annotations.Handle
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.SOURCE)
public @interface Handler {
}
