/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.exception;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.exception.EventProcessingException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;

public class ExpectedError
implements TestRule {
    private Matcher<String> messageMatcher = null;
    private ErrorTypeMatcher errorTypeMatcher = null;
    private Matcher<? extends Throwable> causeMatcher = null;
    private Matcher<? extends CoreEvent> eventMatcher = null;
    private Matcher<? extends Component> failingComponentMatcher;
    private Matcher<? extends Message> errorMessageMatcher = null;
    private List<Matcher> matchers = new ArrayList<Matcher>();

    public static ExpectedError none() {
        return new ExpectedError();
    }

    private ExpectedError() {
    }

    public Statement apply(Statement statement, Description description) {
        return new ExpectedErrorStatement(statement);
    }

    public void expectError(String namespace, String errorTypeDefinition, Class<?> cause, String message) {
        this.expectErrorType(namespace, errorTypeDefinition).expectCause((Matcher<? extends Throwable>)CoreMatchers.instanceOf(cause)).expectMessage((Matcher<String>)CoreMatchers.containsString((String)message));
    }

    public void expectError(String namespace, ErrorTypeDefinition errorTypeDefinition, Class<?> cause, String message) {
        this.expectError(namespace, errorTypeDefinition.getType(), cause, message);
    }

    public ExpectedError expectMessage(Matcher<String> matcher) {
        this.messageMatcher = matcher;
        return this;
    }

    public ExpectedError expectErrorType(String namespace, String errorType) {
        this.errorTypeMatcher = ErrorTypeMatcher.errorType((String)namespace, (String)errorType);
        return this;
    }

    public ExpectedError expectErrorType(Matcher<String> namespaceMatcher, Matcher<String> errorTypeMatcher) {
        this.errorTypeMatcher = ErrorTypeMatcher.errorType(namespaceMatcher, errorTypeMatcher);
        return this;
    }

    public ExpectedError expectErrorType(ErrorTypeMatcher matcher) {
        this.errorTypeMatcher = matcher;
        return this;
    }

    public ExpectedError expectCause(Matcher<? extends Throwable> expectedCause) {
        this.causeMatcher = expectedCause;
        return this;
    }

    public ExpectedError expectEvent(Matcher<? extends CoreEvent> eventMatcher) {
        this.eventMatcher = eventMatcher;
        return this;
    }

    public ExpectedError expectFailingComponent(Matcher<? extends Component> failingComponentMatcher) {
        this.failingComponentMatcher = failingComponentMatcher;
        return this;
    }

    public ExpectedError expectErrorMessage(Matcher<? extends Message> errorEventMatcher) {
        this.errorMessageMatcher = errorEventMatcher;
        return this;
    }

    private boolean expectsThrowable() {
        return this.errorTypeMatcher != null || this.causeMatcher != null || this.eventMatcher != null || this.failingComponentMatcher != null || this.errorMessageMatcher != null || this.messageMatcher != null;
    }

    private void failDueToMissingException() {
        Assert.fail((String)String.format("No exception was thrown during the test \n %s", this.toString()));
    }

    private void failWithNonMatchingException(Exception e) {
        Assert.fail((String)String.format("An exception was caught but it didn't met the following conditions:\n %s \n Caught exception was:\n %s %s", Joiner.on((String)"\n").join(this.matchers), e, Throwables.getStackTraceAsString((Throwable)e)));
    }

    private void failDueToUnexpectedException(Throwable e) {
        Assert.fail((String)String.format("An exception was caught but it wasn't expected for the test \n Caught exception was:\n %s %s", e, Throwables.getStackTraceAsString((Throwable)e)));
    }

    private void failDueToExceptionWithoutError(Throwable e, CoreEvent event) {
        Assert.fail((String)String.format("An exception was caught but it didn't contain information about the error \n Event: \n %s \n Caught exception was:\n %s %s", event, e, Throwables.getStackTraceAsString((Throwable)e)));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EventProcessingException matcher with:\n");
        if (this.errorTypeMatcher != null) {
            builder.append(String.format("* An error: %s\n", this.errorTypeMatcher));
        }
        if (this.causeMatcher != null) {
            builder.append(String.format("* A cause: %s\n", this.causeMatcher));
        }
        if (this.messageMatcher != null) {
            builder.append(String.format("* A message: %s\n", this.messageMatcher));
        }
        if (this.eventMatcher != null) {
            builder.append(String.format("* An event: %s\n", this.eventMatcher));
        }
        if (this.failingComponentMatcher != null) {
            builder.append(String.format("* A failingComponent: %s\n", this.failingComponentMatcher));
        }
        if (this.errorMessageMatcher != null) {
            builder.append(String.format("* An error Message: %s\n", this.errorMessageMatcher));
        }
        return builder.toString();
    }

    private class ExpectedErrorStatement
    extends Statement {
        private final Statement statement;

        public ExpectedErrorStatement(Statement base) {
            this.statement = base;
        }

        public void evaluate() throws Throwable {
            try {
                this.statement.evaluate();
            }
            catch (EventProcessingException exception) {
                CoreEvent event;
                if (!ExpectedError.this.expectsThrowable()) {
                    ExpectedError.this.failDueToUnexpectedException(exception);
                }
                if (!(event = exception.getEvent()).getError().isPresent()) {
                    ExpectedError.this.failDueToExceptionWithoutError(exception, event);
                }
                Error error = (Error)event.getError().get();
                if (ExpectedError.this.errorTypeMatcher != null && !ExpectedError.this.errorTypeMatcher.matches((Object)error.getErrorType())) {
                    ExpectedError.this.matchers.add(ExpectedError.this.errorTypeMatcher);
                }
                if (ExpectedError.this.causeMatcher != null && !ExpectedError.this.causeMatcher.matches((Object)error.getCause())) {
                    ExpectedError.this.matchers.add(ExpectedError.this.causeMatcher);
                }
                if (ExpectedError.this.messageMatcher != null && !ExpectedError.this.messageMatcher.matches((Object)error.getDescription())) {
                    ExpectedError.this.matchers.add(ExpectedError.this.messageMatcher);
                }
                if (ExpectedError.this.failingComponentMatcher != null && !ExpectedError.this.failingComponentMatcher.matches((Object)exception.getFailingComponent())) {
                    ExpectedError.this.matchers.add(ExpectedError.this.failingComponentMatcher);
                }
                if (ExpectedError.this.eventMatcher != null && !ExpectedError.this.eventMatcher.matches((Object)event)) {
                    ExpectedError.this.matchers.add(ExpectedError.this.eventMatcher);
                }
                if (ExpectedError.this.errorMessageMatcher != null && !ExpectedError.this.errorMessageMatcher.matches((Object)error.getErrorMessage())) {
                    ExpectedError.this.matchers.add(ExpectedError.this.errorMessageMatcher);
                }
                if (!ExpectedError.this.matchers.isEmpty()) {
                    ExpectedError.this.failWithNonMatchingException((Exception)((Object)exception));
                }
                return;
            }
            catch (AssumptionViolatedException exception) {
                throw exception;
            }
            catch (Throwable throwable) {
                ExpectedError.this.failDueToUnexpectedException(throwable);
            }
            if (ExpectedError.this.expectsThrowable()) {
                ExpectedError.this.failDueToMissingException();
            }
        }
    }
}

