/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.Serializable;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.session.DefaultMuleSession;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;

public class EventBenchmark
extends AbstractBenchmark {
    public static final String KEY = "key";
    public static final String VALUE = "value";
    private MuleContext muleContext;
    private Flow flow;
    private Event event;
    private Event eventWith10VariablesProperties;
    private Event eventWith50VariablesProperties;
    private Event eventWith100VariablesProperties;

    @Setup
    public void setup() throws Exception {
        this.muleContext = this.createMuleContextWithServices();
        this.muleContext.start();
        this.flow = this.createFlow(this.muleContext);
        this.muleContext.getRegistry().registerFlowConstruct((FlowConstruct)this.flow);
        Message.Builder messageBuilder = Message.builder().payload((Object)PAYLOAD);
        Event.Builder eventBuilder = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flow, (ComponentLocation)CONNECTOR_LOCATION)).message(messageBuilder.build());
        this.event = eventBuilder.build();
        this.eventWith10VariablesProperties = this.createMuleEventWithFlowVarsAndProperties(10);
        this.eventWith50VariablesProperties = this.createMuleEventWithFlowVarsAndProperties(50);
        this.eventWith100VariablesProperties = this.createMuleEventWithFlowVarsAndProperties(50);
    }

    @TearDown
    public void teardown() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.muleContext.getRegistry().lookupObject(SchedulerService.class));
        this.muleContext.dispose();
    }

    @Benchmark
    public Event createEvent() {
        return Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flow, (ComponentLocation)CONNECTOR_LOCATION)).message(Message.of((Object)PAYLOAD)).build();
    }

    @Benchmark
    public Event copyEvent() {
        return Event.builder((Event)this.event).build();
    }

    @Benchmark
    public Event copyEventWith20VariablesProperties() {
        return Event.builder((Event)this.eventWith10VariablesProperties).build();
    }

    @Benchmark
    public Event copyEventWith100VariablesProperties() {
        return Event.builder((Event)this.eventWith100VariablesProperties).build();
    }

    @Benchmark
    public Event deepCopyEvent() {
        return Event.builder((Event)this.event).message(Message.builder((Message)this.event.getMessage()).build()).build();
    }

    @Benchmark
    public Event deepCopyEventWith20VariablesProperties() {
        return Event.builder((Event)this.eventWith10VariablesProperties).message(Message.builder((Message)this.eventWith10VariablesProperties.getMessage()).build()).build();
    }

    @Benchmark
    public Event deepCopyEventWith50VariablesProperties() {
        return Event.builder((Event)this.eventWith50VariablesProperties).message(Message.builder((Message)this.eventWith50VariablesProperties.getMessage()).build()).build();
    }

    @Benchmark
    public Event deepCopyEventWith100VariablesProperties() {
        return Event.builder((Event)this.eventWith100VariablesProperties).message(Message.builder((Message)this.eventWith100VariablesProperties.getMessage()).build()).build();
    }

    @Benchmark
    public Event addEventVariable() {
        return Event.builder((Event)this.event).addVariable(KEY, (Object)VALUE).build();
    }

    @Benchmark
    public Event addEventVariableEventWith20VariablesProperties() {
        return Event.builder((Event)this.eventWith10VariablesProperties).addVariable(KEY, (Object)VALUE).build();
    }

    @Benchmark
    public Event addEventVariableEventWith50VariablesProperties() {
        return Event.builder((Event)this.eventWith50VariablesProperties).addVariable(KEY, (Object)VALUE).build();
    }

    @Benchmark
    public Event addEventVariableEventWith100VariablesProperties() {
        return Event.builder((Event)this.eventWith100VariablesProperties).addVariable(KEY, (Object)VALUE).build();
    }

    @Benchmark
    public Event copyWith10FlowVarsAnd10PropertiesWrite1OfEach() throws Exception {
        return Event.builder((Event)this.eventWith10VariablesProperties).session((MuleSession)new DefaultMuleSession(this.eventWith10VariablesProperties.getSession())).addVariable("newKey", (Object)"val").message((Message)InternalMessage.builder((Message)this.eventWith10VariablesProperties.getMessage()).addInboundProperty("newKey", (Serializable)((Object)"val")).addOutboundProperty("newKey", (Serializable)((Object)"val")).build()).build();
    }

    @Benchmark
    public Event copyWith10FlowVarsAnd10PropertiesWrite5OfEach() throws Exception {
        Event.Builder eventBuilder = Event.builder((Event)this.eventWith50VariablesProperties);
        eventBuilder.session((MuleSession)new DefaultMuleSession(this.eventWith50VariablesProperties.getSession())).build();
        InternalMessage.Builder builder = InternalMessage.builder((Message)this.eventWith50VariablesProperties.getMessage());
        for (int j = 1; j <= 5; ++j) {
            eventBuilder.addVariable("newKey" + j, (Object)"val");
            builder.addInboundProperty("newKey", (Serializable)((Object)"val")).addOutboundProperty("newKey", (Serializable)((Object)"val")).build();
        }
        return eventBuilder.message((Message)builder.build()).build();
    }

    @Benchmark
    public Event copyWith50FlowVarsAnd50PropertiesWrite1OfEach() throws Exception {
        return Event.builder((Event)this.eventWith50VariablesProperties).session((MuleSession)new DefaultMuleSession(this.eventWith50VariablesProperties.getSession())).addVariable("newKey", (Object)"val").message((Message)InternalMessage.builder((Message)this.eventWith50VariablesProperties.getMessage()).addInboundProperty("newKey", (Serializable)((Object)"val")).addOutboundProperty("newKey", (Serializable)((Object)"val")).build()).build();
    }

    @Benchmark
    public Event copyWith100FlowVarsAndPropertiesWrite25OfEach() throws Exception {
        Event.Builder eventBuilder = Event.builder((Event)this.eventWith100VariablesProperties);
        eventBuilder.session((MuleSession)new DefaultMuleSession(this.eventWith100VariablesProperties.getSession())).build();
        InternalMessage.Builder builder = InternalMessage.builder((Message)this.eventWith100VariablesProperties.getMessage());
        for (int j = 1; j <= 25; ++j) {
            eventBuilder.addVariable("newKey" + j, (Object)"val");
            builder.addInboundProperty("newKey", (Serializable)((Object)"val")).addOutboundProperty("newKey", (Serializable)((Object)"val")).build();
        }
        return eventBuilder.message((Message)builder.build()).build();
    }

    private Event createMuleEvent(Message message, int numProperties) {
        Event.Builder builder;
        try {
            builder = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flow, (ComponentLocation)CONNECTOR_LOCATION)).message(message);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (int i = 1; i <= numProperties; ++i) {
            builder.addVariable("FlOwVaRiAbLeKeY" + i, (Object)"val");
        }
        return builder.build();
    }

    private Event createMuleEventWithFlowVarsAndProperties(int numProperties) {
        InternalMessage.Builder builder = InternalMessage.builder().payload((Object)PAYLOAD);
        for (int i = 1; i <= numProperties; ++i) {
            builder.addInboundProperty("InBoUnDpRoPeRtYkEy" + i, (Serializable)((Object)"val"));
        }
        InternalMessage message = builder.build();
        Event event = this.createMuleEvent((Message)message, numProperties);
        return event;
    }
}

