/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util.ftp;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.mule.util.IOUtils;

public class FtpClient {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    FTPClient ftpClient = null;
    String server = null;
    int port;
    String user = null;
    String password = null;
    public static final int TIMEOUT = 5000;

    public FtpClient(String server, int port, String user, String password) {
        this.server = server;
        this.port = port;
        this.user = user;
        this.password = password;
        this.ftpClient = new FTPClient();
    }

    public boolean testConnection() throws IOException {
        this.connect();
        return this.verifyStatusCode(this.ftpClient.noop());
    }

    public String[] getFileList(String path) throws IOException {
        this.connect();
        return this.ftpClient.listNames(path);
    }

    public boolean makeDir(String dir) throws IOException {
        this.connect();
        return this.verifyStatusCode(this.ftpClient.mkd(dir));
    }

    public boolean deleteDir(String dir) throws IOException {
        this.connect();
        return this.verifyStatusCode(this.ftpClient.rmd(dir));
    }

    private boolean verifyStatusCode(int status) {
        return status >= 200 && status < 300;
    }

    public boolean putFile(String fileName, String targetDir) throws IOException {
        this.connect();
        File file = new File(IOUtils.getResourceAsUrl((String)fileName, this.getClass()).getFile());
        return this.ftpClient.storeFile(targetDir + "/" + file.getName(), IOUtils.getResourceAsStream((String)fileName, this.getClass()));
    }

    public boolean putFile(String fileName, String targetDir, String fileContent) throws IOException {
        this.connect();
        return this.ftpClient.storeFile(targetDir + "/" + fileName, (InputStream)new ByteArrayInputStream(fileContent.getBytes()));
    }

    public boolean dirExists(String path) throws IOException {
        this.connect();
        String cwd = this.ftpClient.printWorkingDirectory();
        boolean dirExists = this.ftpClient.changeWorkingDirectory(path);
        this.ftpClient.changeWorkingDirectory(cwd);
        return dirExists;
    }

    public void recursiveDelete(String path) throws IOException {
        this.connect();
        String cwd = this.ftpClient.printWorkingDirectory();
        System.out.println("CWD: " + cwd);
        this.ftpClient.changeWorkingDirectory(path);
        System.out.println("Changed CWD: " + path);
        FTPFile[] fileObjs = this.ftpClient.listFiles();
        for (int i = 0; i < fileObjs.length; ++i) {
            if (fileObjs[i].isFile()) {
                this.ftpClient.deleteFile(fileObjs[i].getName());
                continue;
            }
            if (fileObjs[i].isDirectory() && this.getFileList(this.ftpClient.printWorkingDirectory() + "/" + fileObjs[i].getName()).length > 0) {
                this.recursiveDelete(this.ftpClient.printWorkingDirectory() + "/" + fileObjs[i].getName());
                this.deleteDir(this.ftpClient.printWorkingDirectory() + "/" + fileObjs[i].getName());
                continue;
            }
            if (!fileObjs[i].isDirectory()) continue;
            this.deleteDir(this.ftpClient.printWorkingDirectory() + "/" + fileObjs[i].getName());
        }
        this.ftpClient.changeWorkingDirectory(cwd);
    }

    protected void connect() throws IOException {
        if (!this.ftpClient.isConnected()) {
            this.ftpClient = new FTPClient();
            this.ftpClient.setDefaultTimeout(5000);
            this.ftpClient.connect(this.server, this.port);
            this.ftpClient.login(this.user, this.password);
        }
    }

    public boolean isConnected() {
        return this.ftpClient.isConnected();
    }

    public void disconnect() throws IOException {
        this.ftpClient.disconnect();
    }

    public boolean fileExists(String file) throws IOException {
        return this.ftpClient.listFiles(file).length > 0;
    }

    public boolean deleteFile(String name) throws IOException {
        return this.ftpClient.deleteFile(name);
    }

    public boolean expectFileCount(String directory, int count, long timeout) throws InterruptedException, IOException {
        long endTime = System.currentTimeMillis() + timeout;
        int iteration = 1;
        while (System.currentTimeMillis() < endTime) {
            this.logger.debug((Object)("checking file list, iteration :" + iteration));
            if (this.getFileList(directory).length == count) {
                this.logger.debug((Object)("found expected file count : " + count));
                return true;
            }
            Thread.sleep(1000L);
            ++iteration;
        }
        return false;
    }
}

