/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.simple;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.expression.transformers.BeanBuilderTransformer;
import org.mule.expression.transformers.ExpressionArgument;
import org.mule.expression.transformers.ExpressionTransformer;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.FruitBasket;
import org.mule.tck.testmodels.fruit.FruitBowl;

public class ExpressionTransformerELTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/transformers/expression-transformers-el-test.xml";
    }

    private void testTransformerConfig(String name) throws Exception {
        ExpressionTransformer transformer = (ExpressionTransformer)muleContext.getRegistry().lookupTransformer(name);
        Assert.assertNotNull((Object)transformer);
        Assert.assertNotNull((Object)transformer.getArguments());
        Assert.assertEquals((long)2L, (long)transformer.getArguments().size());
        ExpressionArgument arg1 = (ExpressionArgument)transformer.getArguments().get(0);
        Assert.assertNull((Object)arg1.getEvaluator());
        Assert.assertEquals((Object)"message.payloadAs(org.mule.tck.testmodels.fruit.FruitBasket)", (Object)arg1.getExpression());
        Assert.assertFalse((boolean)arg1.isOptional());
        ExpressionArgument arg2 = (ExpressionArgument)transformer.getArguments().get(1);
        Assert.assertEquals((Object)"headers", (Object)arg2.getEvaluator());
        Assert.assertEquals((Object)"foo,bar?", (Object)arg2.getExpression());
        Assert.assertTrue((boolean)arg2.isOptional());
    }

    @Test
    public void testTransformerConfig() throws Exception {
        this.testTransformerConfig("testTransformer");
    }

    @Test
    public void testBeanBuilderTransformerConfig() throws Exception {
        this.testBeanBuilderTransformerConfig("testTransformer3");
    }

    private void testBeanBuilderTransformerConfig(String name) throws Exception {
        BeanBuilderTransformer transformer = (BeanBuilderTransformer)muleContext.getRegistry().lookupTransformer(name);
        Assert.assertNotNull((Object)transformer);
        Assert.assertNotNull((Object)transformer.getArguments());
        Assert.assertEquals((long)3L, (long)transformer.getArguments().size());
        ExpressionArgument arg1 = (ExpressionArgument)transformer.getArguments().get(0);
        Assert.assertEquals((Object)"brand", (Object)arg1.getName());
        Assert.assertNull((Object)arg1.getEvaluator());
        Assert.assertEquals((Object)"payload", (Object)arg1.getExpression());
        Assert.assertFalse((boolean)arg1.isOptional());
        ExpressionArgument arg2 = (ExpressionArgument)transformer.getArguments().get(1);
        Assert.assertEquals((Object)"segments", (Object)arg2.getName());
        Assert.assertNull((Object)arg2.getEvaluator());
        Assert.assertEquals((Object)"message.outboundProperties['SEGMENTS']", (Object)arg2.getExpression());
        Assert.assertTrue((boolean)arg2.isOptional());
    }

    @Test
    public void testExecutionWithCorrectMessage() throws Exception {
        this.testExecutionWithCorrectMessage("testTransformer");
    }

    private void testExecutionWithCorrectMessage(String name) throws Exception {
        ExpressionTransformer transformer = (ExpressionTransformer)muleContext.getRegistry().lookupTransformer(name);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("foo", "moo");
        props.put("bar", "mar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new FruitBowl(new Apple(), new Banana()), props, muleContext);
        Object result = transformer.transform((Object)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.getClass().isArray());
        Object o1 = ((Object[])result)[0];
        Assert.assertTrue((boolean)(o1 instanceof FruitBasket));
        Object o2 = ((Object[])result)[1];
        Assert.assertTrue((boolean)(o2 instanceof Map));
        Map map = (Map)o2;
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"moo", map.get("foo"));
        Assert.assertEquals((Object)"mar", map.get("bar"));
    }

    @Test
    public void testExecutionWithPartialMissingOptionalParams() throws Exception {
        ExpressionTransformer transformer = (ExpressionTransformer)muleContext.getRegistry().lookupTransformer("testTransformer");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("foo", "moo");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new FruitBowl(new Apple(), new Banana()), props, muleContext);
        Object result = transformer.transform((Object)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.getClass().isArray());
        Object o1 = ((Object[])result)[0];
        Assert.assertTrue((boolean)(o1 instanceof FruitBasket));
        Object o2 = ((Object[])result)[1];
        Assert.assertTrue((boolean)(o2 instanceof Map));
        Map map = (Map)o2;
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"moo", map.get("foo"));
    }

    @Test
    public void testExecutionWithAllMissingOptionalParams() throws Exception {
        ExpressionTransformer transformer = (ExpressionTransformer)muleContext.getRegistry().lookupTransformer("testTransformer");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new FruitBowl(new Apple(), new Banana()), muleContext);
        Object result = transformer.transform((Object)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.getClass().isArray());
        Object o1 = ((Object[])result)[0];
        Assert.assertTrue((boolean)(o1 instanceof FruitBasket));
        Assert.assertNull((Object)((Object[])result)[1]);
    }

    @Test
    public void testTransformerConfigWithSingleArgument() throws Exception {
        ExpressionTransformer transformer = (ExpressionTransformer)muleContext.getRegistry().lookupTransformer("testTransformer2");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("foo", "moo");
        props.put("bar", "mar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new FruitBowl(new Apple(), new Banana()), props, muleContext);
        Object result = transformer.transform((Object)message);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.getClass().isArray());
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertTrue((boolean)list.contains("moo"));
        Assert.assertTrue((boolean)list.contains("mar"));
    }

    @Test
    public void testTransformerConfigWithSingleArgumentShortcutConfig() throws Exception {
        this.testTransformerConfigWithSingleArgumentShortcutConfig("testTransformer4");
    }

    private void testTransformerConfigWithSingleArgumentShortcutConfig(String name) throws Exception {
        ExpressionTransformer transformer = (ExpressionTransformer)muleContext.getRegistry().lookupTransformer(name);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("foo", "moo");
        props.put("bar", "mar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new FruitBowl(new Apple(), new Banana()), props, muleContext);
        Object result = transformer.transform((Object)message);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.getClass().isArray());
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertTrue((boolean)list.contains("moo"));
        Assert.assertTrue((boolean)list.contains("mar"));
    }
}

