/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.EncryptionStrategy;
import org.mule.api.security.SecurityManager;
import org.mule.security.PasswordBasedEncryptionStrategy;
import org.mule.security.SecretKeyEncryptionStrategy;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.security.MockEncryptionStrategy;
import org.mule.tck.security.TestSingleUserSecurityProvider;

public class SecurityNamespaceHandlerTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "security-namespace-config.xml";
    }

    @Test
    public void testSecurity() {
        SecurityManager securityManager = muleContext.getSecurityManager();
        Assert.assertNotNull((Object)securityManager.getProvider("dummySecurityProvider"));
        Assert.assertTrue((boolean)(securityManager.getProvider("dummySecurityProvider") instanceof TestSingleUserSecurityProvider));
        this.verifyEncryptionStrategy(securityManager, "dummyEncryptionStrategy", MockEncryptionStrategy.class);
        this.verifyEncryptionStrategy(securityManager, "passwordEncryptionStrategy", PasswordBasedEncryptionStrategy.class);
        this.verifyEncryptionStrategy(securityManager, "secretKeyEncryptionStrategy", SecretKeyEncryptionStrategy.class);
    }

    private void verifyEncryptionStrategy(SecurityManager securityManager, String name, Class clazz) {
        Iterator strategies = securityManager.getEncryptionStrategies().iterator();
        this.logger.debug((Object)"Listing strategies");
        while (strategies.hasNext()) {
            EncryptionStrategy strategy = (EncryptionStrategy)strategies.next();
            this.logger.debug((Object)(strategy.getName() + " / " + strategy.toString() + " / " + strategy.getClass()));
        }
        Assert.assertNotNull((String)name, (Object)securityManager.getEncryptionStrategy(name));
        Assert.assertTrue((boolean)securityManager.getEncryptionStrategy(name).getClass().equals(clazz));
    }
}

