/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.routing.filters.ExpressionFilter;
import org.mule.tck.junit4.FunctionalTestCase;

public class ExpressionFilterConfigTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/config/expression-filter-config.xml";
    }

    @Test
    public void testConfig1() throws Exception {
        EndpointBuilder eb = muleContext.getRegistry().lookupEndpointBuilder("endpoint1");
        Assert.assertNotNull((Object)eb);
        InboundEndpoint ep = eb.buildInboundEndpoint();
        Assert.assertNotNull((Object)ep.getFilter());
        Assert.assertTrue((boolean)(ep.getFilter() instanceof ExpressionFilter));
        ExpressionFilter filter = (ExpressionFilter)ep.getFilter();
        Assert.assertEquals((Object)"payload-type", (Object)filter.getEvaluator());
        Assert.assertEquals((Object)"java.lang.String", (Object)filter.getExpression());
        Assert.assertNull((Object)filter.getCustomEvaluator());
        Assert.assertFalse((boolean)filter.isNullReturnsTrue());
    }

    @Test
    public void testConfig2() throws Exception {
        EndpointBuilder eb = muleContext.getRegistry().lookupEndpointBuilder("endpoint2");
        Assert.assertNotNull((Object)eb);
        InboundEndpoint ep = eb.buildInboundEndpoint();
        Assert.assertNotNull((Object)ep.getFilter());
        Assert.assertTrue((boolean)(ep.getFilter() instanceof ExpressionFilter));
        ExpressionFilter filter = (ExpressionFilter)ep.getFilter();
        Assert.assertEquals((Object)"header", (Object)filter.getEvaluator());
        Assert.assertEquals((Object)"foo=bar", (Object)filter.getExpression());
        Assert.assertNull((Object)filter.getCustomEvaluator());
        Assert.assertTrue((boolean)filter.isNullReturnsTrue());
    }

    @Test
    public void testConfig3() throws Exception {
        EndpointBuilder eb = muleContext.getRegistry().lookupEndpointBuilder("endpoint3");
        Assert.assertNotNull((Object)eb);
        InboundEndpoint ep = eb.buildInboundEndpoint();
        Assert.assertNotNull((Object)ep.getFilter());
        Assert.assertTrue((boolean)(ep.getFilter() instanceof ExpressionFilter));
        ExpressionFilter filter = (ExpressionFilter)ep.getFilter();
        Assert.assertEquals((Object)"custom", (Object)filter.getEvaluator());
        Assert.assertEquals((Object)"a.b.c", (Object)filter.getExpression());
        Assert.assertEquals((Object)"something", (Object)filter.getCustomEvaluator());
        Assert.assertFalse((boolean)filter.isNullReturnsTrue());
    }
}

