/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

@Ignore
public class PartialStartupTestCase
extends FunctionalTestCase {
    public PartialStartupTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigFile() {
        return "org/mule/test/components/partial-startup-test.xml";
    }

    @Test
    public void testStopAfterPartialStartup() throws Exception {
        final List<String> initialThreads = PartialStartupTestCase.collectThreadNames();
        try {
            muleContext.start();
            Assert.fail((String)"Expected Mule to fail to start, due to our RudeMessageProcessor");
        }
        catch (Exception e) {
            System.err.println("Expected Exception:");
            e.printStackTrace();
        }
        muleContext.dispose();
        new PollingProber(10000L, 100L).check(new Probe(){

            public boolean isSatisfied() {
                List currentThreads = PartialStartupTestCase.collectThreadNames();
                return PartialStartupTestCase.countOcurrences(currentThreads, "SHUTDOWN_TEST_FLOW") == 0 && PartialStartupTestCase.countOcurrences(initialThreads, "MuleServer") == PartialStartupTestCase.countOcurrences(currentThreads, "MuleServer") + 1;
            }

            public String describeFailure() {
                return "mule threads running during dispose";
            }
        });
    }

    private static List<String> collectThreadNames() {
        ArrayList<String> threadNames = new ArrayList<String>();
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            threadNames.add(t.getName());
        }
        return threadNames;
    }

    private static int countOcurrences(List<String> elements, String prefix) {
        int count = 0;
        if (elements != null) {
            for (String element : elements) {
                if (!element.startsWith(prefix)) continue;
                ++count;
            }
        }
        return count;
    }
}

