/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.tck.exceptions.FunctionalTestException;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class FunctionalTestComponentTestCase
extends AbstractMuleTestCase {
    FunctionalTestComponent ftc;

    @Before
    public void initFunctionaTestComponent() {
        this.ftc = new FunctionalTestComponent();
        this.ftc.setThrowException(true);
    }

    @Test
    public void defaultExceptionWithDefaultText() throws Exception {
        this.checkExceptionThrown(FunctionalTestException.class, "Functional Test Service Exception");
    }

    @Test
    public void defaultExceptionWithCustomText() throws Exception {
        String exceptionText = "BOOM";
        this.ftc.setExceptionText(exceptionText);
        this.checkExceptionThrown(FunctionalTestException.class, exceptionText);
    }

    @Test
    public void customExceptionWithoutText() throws Exception {
        this.ftc.setExceptionToThrow(IOException.class);
        this.checkExceptionThrown(IOException.class, null);
    }

    @Test
    public void customExceptionWithCustomText() throws Exception {
        String exceptionText = "BOOM";
        this.ftc.setExceptionToThrow(IOException.class);
        this.ftc.setExceptionText(exceptionText);
        this.checkExceptionThrown(IOException.class, exceptionText);
    }

    private void checkExceptionThrown(Class<? extends Exception> exceptionClass, String expectedMessage) {
        try {
            this.ftc.onCall(null);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getClass().isAssignableFrom(exceptionClass));
            Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
        }
    }
}

