/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoints;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class EndpointContentTypeTestCase
extends AbstractServiceAndFlowTestCase {
    public EndpointContentTypeTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "content-type-setting-endpoint-configs-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "content-type-setting-endpoint-configs-flow.xml"});
    }

    @Test
    public void testContentType() throws Exception {
        InboundEndpoint inbound = (InboundEndpoint)muleContext.getRegistry().lookupObject("inbound");
        Assert.assertEquals((Object)"text/xml", (Object)inbound.getMimeType());
        Assert.assertEquals((Object)"utf-8", (Object)inbound.getEncoding());
        OutboundEndpoint outbound = (OutboundEndpoint)muleContext.getRegistry().lookupObject("outbound");
        Assert.assertEquals((Object)"application/json", (Object)outbound.getMimeType());
        Assert.assertEquals((Object)"iso-8859-2", (Object)outbound.getEncoding());
        EndpointBuilder global = muleContext.getRegistry().lookupEndpointBuilder("global");
        InboundEndpoint created = global.buildInboundEndpoint();
        Assert.assertEquals((Object)"application/xml", (Object)created.getMimeType());
        Assert.assertEquals((Object)"iso-8859-1", (Object)created.getEncoding());
    }
}

