/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.processor.NullMessageProcessor;
import org.mule.tck.junit4.FunctionalTestCase;

public class CompositeMessageProcessorDefinitionParserTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/config/spring/parsers/specific/composite-message-processor.xml";
    }

    @Test
    public void testInterceptingComposite() throws Exception {
        MessageProcessor composite = (MessageProcessor)muleContext.getRegistry().lookupObject("composite1");
        Assert.assertEquals((Object)"0123", (Object)composite.process(CompositeMessageProcessorDefinitionParserTestCase.getTestEvent((Object)"0")).getMessageAsString());
    }

    @Test
    public void testInterceptingNestedComposite() throws Exception {
        MessageProcessor composite = (MessageProcessor)muleContext.getRegistry().lookupObject("composite2");
        Assert.assertEquals((Object)"01abc2", (Object)composite.process(CompositeMessageProcessorDefinitionParserTestCase.getTestEvent((Object)"0")).getMessageAsString());
    }

    @Test
    public void testInterceptingCompositeOnEndpoint() throws Exception {
        EndpointBuilder endpointBuilder = muleContext.getRegistry().lookupEndpointBuilder("endpoint");
        InboundEndpoint endpoint = endpointBuilder.buildInboundEndpoint();
        Assert.assertEquals((long)2L, (long)endpoint.getMessageProcessors().size());
        MessageProcessor endpointProcessor = endpoint.getMessageProcessorsFactory().createInboundMessageProcessorChain(endpoint, null, (MessageProcessor)new NullMessageProcessor());
        Assert.assertEquals((Object)"01231abc2", (Object)endpointProcessor.process(CompositeMessageProcessorDefinitionParserTestCase.getTestEvent((Object)"0")).getMessageAsString());
    }
}

