/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.handlers;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.retry.RetryNotifier;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.transport.Connector;
import org.mule.config.spring.handlers.TestRetryNotifier;
import org.mule.config.spring.handlers.TestRetryPolicyTemplate;
import org.mule.retry.async.AsynchronousRetryTemplate;
import org.mule.retry.notifiers.ConnectNotifier;
import org.mule.retry.policies.NoRetryPolicyTemplate;
import org.mule.retry.policies.RetryForeverPolicyTemplate;
import org.mule.retry.policies.SimpleRetryPolicyTemplate;
import org.mule.tck.junit4.FunctionalTestCase;

public class RetryNamespaceHandlerTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/config/spring/handlers/retry-namespace-config.xml";
    }

    @Test
    public void testDefaultConfig() throws Exception {
        Connector c = muleContext.getRegistry().lookupConnector("testConnector1");
        Assert.assertNotNull((Object)c);
        RetryPolicyTemplate rpf = c.getRetryPolicyTemplate();
        Assert.assertNotNull((Object)rpf);
        Assert.assertTrue((boolean)(rpf instanceof NoRetryPolicyTemplate));
        RetryNotifier rn = rpf.getNotifier();
        Assert.assertNotNull((Object)rn);
        Assert.assertTrue((boolean)(rn instanceof ConnectNotifier));
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
    }

    @Test
    public void testSimpleDefaults() throws Exception {
        Connector c = muleContext.getRegistry().lookupConnector("testConnector2");
        Assert.assertNotNull((Object)c);
        RetryPolicyTemplate rpf = c.getRetryPolicyTemplate();
        Assert.assertNotNull((Object)rpf);
        Assert.assertTrue((boolean)(rpf instanceof SimpleRetryPolicyTemplate));
        Assert.assertEquals((long)2L, (long)((SimpleRetryPolicyTemplate)rpf).getCount());
        Assert.assertEquals((long)2000L, (long)((SimpleRetryPolicyTemplate)rpf).getFrequency());
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
    }

    @Test
    public void testSimpleConfig() throws Exception {
        Connector c = muleContext.getRegistry().lookupConnector("testConnector3");
        Assert.assertNotNull((Object)c);
        RetryPolicyTemplate rpf = c.getRetryPolicyTemplate();
        Assert.assertNotNull((Object)rpf);
        Assert.assertTrue((boolean)(rpf instanceof SimpleRetryPolicyTemplate));
        Assert.assertEquals((long)5L, (long)((SimpleRetryPolicyTemplate)rpf).getCount());
        Assert.assertEquals((long)1000L, (long)((SimpleRetryPolicyTemplate)rpf).getFrequency());
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
    }

    @Test
    public void testForeverConfig() throws Exception {
        Connector c = muleContext.getRegistry().lookupConnector("testConnector4");
        Assert.assertNotNull((Object)c);
        RetryPolicyTemplate rpf = c.getRetryPolicyTemplate();
        Assert.assertNotNull((Object)rpf);
        Assert.assertTrue((boolean)(rpf instanceof RetryForeverPolicyTemplate));
        Assert.assertEquals((long)5000L, (long)((RetryForeverPolicyTemplate)rpf).getFrequency());
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
    }

    @Test
    public void testCustomConfig() throws Exception {
        Connector c = muleContext.getRegistry().lookupConnector("testConnector5");
        Assert.assertNotNull((Object)c);
        RetryPolicyTemplate rpf = c.getRetryPolicyTemplate();
        Assert.assertNotNull((Object)rpf);
        Assert.assertTrue((boolean)(rpf instanceof TestRetryPolicyTemplate));
        Assert.assertTrue((boolean)((TestRetryPolicyTemplate)rpf).isFooBar());
        Assert.assertEquals((long)500L, (long)((TestRetryPolicyTemplate)rpf).getRevolutions());
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
    }

    @Test
    public void testConnectNotifierConfig() throws Exception {
        Connector c = muleContext.getRegistry().lookupConnector("testConnector6");
        Assert.assertNotNull((Object)c);
        RetryPolicyTemplate rpf = c.getRetryPolicyTemplate();
        Assert.assertNotNull((Object)rpf);
        RetryNotifier rn = rpf.getNotifier();
        Assert.assertNotNull((Object)rn);
        Assert.assertTrue((boolean)(rn instanceof ConnectNotifier));
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
    }

    @Test
    public void testCustomNotifierConfig() throws Exception {
        Connector c = muleContext.getRegistry().lookupConnector("testConnector7");
        Assert.assertNotNull((Object)c);
        RetryPolicyTemplate rpf = c.getRetryPolicyTemplate();
        Assert.assertNotNull((Object)rpf);
        RetryNotifier rn = rpf.getNotifier();
        Assert.assertNotNull((Object)rn);
        Assert.assertTrue((boolean)(rn instanceof TestRetryNotifier));
        Assert.assertEquals((Object)"red", (Object)((TestRetryNotifier)rn).getColor());
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
    }

    @Test
    public void testAsynchronousRetryConfig() throws Exception {
        Connector c = muleContext.getRegistry().lookupConnector("testConnector8");
        Assert.assertNotNull((Object)c);
        RetryPolicyTemplate rpf = c.getRetryPolicyTemplate();
        Assert.assertNotNull((Object)rpf);
        Assert.assertTrue((boolean)(rpf instanceof AsynchronousRetryTemplate));
        rpf = ((AsynchronousRetryTemplate)rpf).getDelegate();
        Assert.assertTrue((boolean)(rpf instanceof SimpleRetryPolicyTemplate));
        Assert.assertEquals((long)5L, (long)((SimpleRetryPolicyTemplate)rpf).getCount());
        Assert.assertEquals((long)1000L, (long)((SimpleRetryPolicyTemplate)rpf).getFrequency());
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
    }
}

