/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.functional;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;
import org.mule.api.MuleEventContext;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.functional.EventCallback;

public class CountdownCallback
implements EventCallback {
    private CountDownLatch countDown;

    public CountdownCallback(int messagesExpected) {
        this.countDown = new CountDownLatch(messagesExpected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventReceived(MuleEventContext context, Object Component2) throws Exception {
        CountdownCallback countdownCallback = this;
        synchronized (countdownCallback) {
            if (this.countDown.getCount() <= 0L) {
                throw new AssertionFailedError("Too many messages received");
            }
            this.countDown.countDown();
        }
    }

    public long getCount() throws InitialisationException {
        if (this.countDown != null) {
            return this.countDown.getCount();
        }
        throw new InitialisationException(MessageFactory.createStaticMessage((String)"CountDownLatch has not been initialized."), null);
    }

    public boolean await(long timeout) throws InterruptedException {
        return this.countDown.await(timeout, TimeUnit.MILLISECONDS);
    }
}

