/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.component.InterfaceBinding;
import org.mule.api.component.JavaComponent;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.interceptor.Interceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.routing.filter.Filter;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.component.AbstractComponent;
import org.mule.component.PooledJavaComponent;
import org.mule.config.PoolingProfile;
import org.mule.config.QueueProfile;
import org.mule.interceptor.InterceptorStack;
import org.mule.interceptor.LoggingInterceptor;
import org.mule.interceptor.TimerInterceptor;
import org.mule.model.seda.SedaService;
import org.mule.routing.IdempotentMessageFilter;
import org.mule.routing.MessageFilter;
import org.mule.routing.filters.MessagePropertyFilter;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.filters.RegExFilter;
import org.mule.routing.filters.logic.AndFilter;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.tck.AbstractScriptConfigBuilderTestCase;
import org.mule.tck.testmodels.mule.TestCatchAllStrategy;
import org.mule.tck.testmodels.mule.TestCompressionTransformer;
import org.mule.tck.testmodels.mule.TestExceptionStrategy;
import org.mule.tck.testmodels.mule.TestTransactionFactory;
import org.mule.transformer.TransformerUtils;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.AbstractConnector;

public abstract class AbstractConfigBuilderTestCase
extends AbstractScriptConfigBuilderTestCase {
    public AbstractConfigBuilderTestCase(boolean legacy) {
        super(legacy);
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    @Override
    public void testManagerConfig() throws Exception {
        super.testManagerConfig();
        Assert.assertNotNull((Object)muleContext.getTransactionManager());
    }

    @Override
    public void testConnectorConfig() throws Exception {
        super.testConnectorConfig();
        MessagingExceptionHandler es = muleContext.getRegistry().lookupModel("main").getExceptionListener();
        Assert.assertNotNull((Object)es);
        Assert.assertTrue((String)es.getClass().getName(), (boolean)(es instanceof TestExceptionStrategy));
    }

    @Override
    public void testGlobalEndpointConfig() throws MuleException {
        super.testGlobalEndpointConfig();
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("fruitBowlEndpoint");
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals((Object)endpoint.getEndpointURI().getAddress(), (Object)"fruitBowlPublishQ");
        MessagePropertyFilter filter = (MessagePropertyFilter)endpoint.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertEquals((Object)"foo=bar", (Object)filter.getPattern());
    }

    @Override
    public void testEndpointConfig() throws MuleException {
        super.testEndpointConfig();
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("waterMelonEndpoint");
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals((Object)"UTF-8-TEST", (Object)endpoint.getEncoding());
        Assert.assertEquals((Object)"test.queue", (Object)endpoint.getEndpointURI().getAddress());
        Service service = muleContext.getRegistry().lookupService("appleComponent2");
        Assert.assertNotNull((Object)service);
    }

    @Test
    public void testExceptionStrategy2() {
        Service service = muleContext.getRegistry().lookupService("appleComponent");
        Assert.assertNotNull((Object)service.getExceptionListener());
        Assert.assertTrue((boolean)(service.getExceptionListener() instanceof MessagingExceptionHandler));
    }

    @Override
    public void testTransformerConfig() {
        super.testTransformerConfig();
        Transformer t = muleContext.getRegistry().lookupTransformer("TestCompressionTransformer");
        Assert.assertNotNull((Object)t);
        Assert.assertTrue((boolean)(t instanceof TestCompressionTransformer));
        Assert.assertEquals((Object)t.getReturnDataType(), (Object)DataTypeFactory.STRING);
        Assert.assertNotNull((Object)((TestCompressionTransformer)t).getContainerProperty());
    }

    @Override
    public void testModelConfig() throws Exception {
        super.testModelConfig();
        Assert.assertNotNull((Object)muleContext.getRegistry().lookupService("appleComponent"));
        Assert.assertNotNull((Object)muleContext.getRegistry().lookupService("appleComponent2"));
    }

    @Test
    public void testOutboundRouterConfig2() {
        Service service = muleContext.getRegistry().lookupService("appleComponent");
        Assert.assertNotNull((Object)service.getOutboundMessageProcessor());
        OutboundRouterCollection router = (OutboundRouterCollection)service.getOutboundMessageProcessor();
        Assert.assertNotNull((Object)router.getCatchAllStrategy());
        Assert.assertEquals((long)2L, (long)router.getRoutes().size());
        OutboundRouter route1 = (OutboundRouter)router.getRoutes().get(0);
        Assert.assertTrue((boolean)(route1 instanceof FilteringOutboundRouter));
        Assert.assertEquals((long)1L, (long)route1.getRoutes().size());
        ImmutableEndpoint ep = (ImmutableEndpoint)route1.getRoutes().get(0);
        Assert.assertNotNull((Object)ep.getTransformers());
        Assert.assertTrue((boolean)(TransformerUtils.firstOrNull((List)ep.getTransformers()) instanceof TestCompressionTransformer));
        Filter filter = ((FilteringOutboundRouter)route1).getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof PayloadTypeFilter));
        Assert.assertEquals(String.class, (Object)((PayloadTypeFilter)filter).getExpectedType());
        OutboundRouter route2 = (OutboundRouter)router.getRoutes().get(1);
        Assert.assertTrue((boolean)(route2 instanceof FilteringOutboundRouter));
        Filter filter2 = ((FilteringOutboundRouter)route2).getFilter();
        Assert.assertNotNull((Object)filter2);
        Assert.assertTrue((boolean)(filter2 instanceof AndFilter));
        Assert.assertEquals((long)2L, (long)((AndFilter)filter2).getFilters().size());
        Filter left = (Filter)((AndFilter)filter2).getFilters().get(0);
        Filter right = (Filter)((AndFilter)filter2).getFilters().get(1);
        Assert.assertNotNull((Object)left);
        Assert.assertTrue((boolean)(left instanceof RegExFilter));
        Assert.assertEquals((Object)"the quick brown (.*)", (Object)((RegExFilter)left).getPattern());
        Assert.assertNotNull((Object)right);
        Assert.assertTrue((boolean)(right instanceof RegExFilter));
        Assert.assertEquals((Object)"(.*) brown (.*)", (Object)((RegExFilter)right).getPattern());
        Assert.assertTrue((boolean)(router.getCatchAllStrategy() instanceof TestCatchAllStrategy));
    }

    @Test
    public void testInboundRouterConfig2() {
        Service service = muleContext.getRegistry().lookupService("appleComponent");
        Assert.assertNotNull((Object)service.getMessageSource());
        ServiceCompositeMessageSource messageRouter = (ServiceCompositeMessageSource)service.getMessageSource();
        Assert.assertNotNull((Object)messageRouter.getCatchAllStrategy());
        Assert.assertEquals((long)2L, (long)messageRouter.getMessageProcessors().size());
        MessageProcessor router = (MessageProcessor)messageRouter.getMessageProcessors().get(0);
        Assert.assertTrue((boolean)(router instanceof MessageFilter));
        MessageFilter sc = (MessageFilter)router;
        Assert.assertNotNull((Object)sc.getFilter());
        Filter filter = sc.getFilter();
        Assert.assertTrue((boolean)(filter instanceof PayloadTypeFilter));
        Assert.assertEquals(String.class, (Object)((PayloadTypeFilter)filter).getExpectedType());
        MessageProcessor router2 = (MessageProcessor)messageRouter.getMessageProcessors().get(1);
        Assert.assertTrue((boolean)(router2 instanceof IdempotentMessageFilter));
    }

    @Test
    public void testThreadingConfig() throws DefaultMuleException {
        int defaultMaxBufferSize = 42;
        int defaultMaxThreadsActive = 16;
        int defaultMaxThreadsIdle = 3;
        int defaultThreadPoolExhaustedAction = 0;
        int defaultThreadTTL = 60001;
        int connectorMaxBufferSize = 2;
        int componentMaxBufferSize = 6;
        int componentMaxThreadsActive = 12;
        int componentMaxThreadsIdle = 6;
        int componentThreadPoolExhaustedAction = 1;
        ThreadingProfile tp = muleContext.getDefaultThreadingProfile();
        Assert.assertEquals((long)defaultMaxBufferSize, (long)tp.getMaxBufferSize());
        Assert.assertEquals((long)defaultMaxThreadsActive, (long)tp.getMaxThreadsActive());
        Assert.assertEquals((long)defaultMaxThreadsIdle, (long)tp.getMaxThreadsIdle());
        Assert.assertEquals((long)defaultThreadPoolExhaustedAction, (long)tp.getPoolExhaustedAction());
        Assert.assertEquals((long)defaultThreadTTL, (long)tp.getThreadTTL());
        tp = muleContext.getDefaultServiceThreadingProfile();
        Assert.assertEquals((long)defaultMaxBufferSize, (long)tp.getMaxBufferSize());
        Assert.assertEquals((long)defaultMaxThreadsActive, (long)tp.getMaxThreadsActive());
        Assert.assertEquals((long)defaultMaxThreadsIdle, (long)tp.getMaxThreadsIdle());
        Assert.assertEquals((long)defaultThreadPoolExhaustedAction, (long)tp.getPoolExhaustedAction());
        Assert.assertEquals((long)defaultThreadTTL, (long)tp.getThreadTTL());
        AbstractConnector c = (AbstractConnector)muleContext.getRegistry().lookupConnector("dummyConnector");
        tp = c.getDispatcherThreadingProfile();
        Assert.assertEquals((long)connectorMaxBufferSize, (long)tp.getMaxBufferSize());
        Assert.assertEquals((long)defaultMaxThreadsActive, (long)tp.getMaxThreadsActive());
        Assert.assertEquals((long)defaultMaxThreadsIdle, (long)tp.getMaxThreadsIdle());
        Assert.assertEquals((long)defaultThreadPoolExhaustedAction, (long)tp.getPoolExhaustedAction());
        Assert.assertEquals((long)defaultThreadTTL, (long)tp.getThreadTTL());
        Service service = muleContext.getRegistry().lookupService("appleComponent2");
        Assert.assertTrue((String)"service must be SedaService to get threading profile", (boolean)(service instanceof SedaService));
        tp = ((SedaService)service).getThreadingProfile();
        Assert.assertEquals((long)componentMaxBufferSize, (long)tp.getMaxBufferSize());
        Assert.assertEquals((long)componentMaxThreadsActive, (long)tp.getMaxThreadsActive());
        Assert.assertEquals((long)componentMaxThreadsIdle, (long)tp.getMaxThreadsIdle());
        Assert.assertEquals((long)componentThreadPoolExhaustedAction, (long)tp.getPoolExhaustedAction());
        Assert.assertEquals((long)defaultThreadTTL, (long)tp.getThreadTTL());
    }

    @Test
    public void testPoolingConfig() {
        Service service = muleContext.getRegistry().lookupService("appleComponent2");
        PoolingProfile pp = ((PooledJavaComponent)service.getComponent()).getPoolingProfile();
        Assert.assertEquals((long)9L, (long)pp.getMaxActive());
        Assert.assertEquals((long)6L, (long)pp.getMaxIdle());
        Assert.assertEquals((long)4002L, (long)pp.getMaxWait());
        Assert.assertEquals((long)0L, (long)pp.getExhaustedAction());
        Assert.assertEquals((long)2L, (long)pp.getInitialisationPolicy());
    }

    @Test
    public void testQueueProfileConfig() {
        Service service = muleContext.getRegistry().lookupService("appleComponent2");
        QueueProfile qp = ((SedaService)service).getQueueProfile();
        Assert.assertEquals((long)102L, (long)qp.getMaxOutstandingMessages());
    }

    @Test
    public void testEndpointProperties() throws Exception {
        Service service = muleContext.getRegistry().lookupService("appleComponent2");
        InboundEndpoint inEndpoint = ((ServiceCompositeMessageSource)service.getMessageSource()).getEndpoint("transactedInboundEndpoint");
        Assert.assertNotNull((Object)inEndpoint);
        Assert.assertNotNull((Object)inEndpoint.getProperties());
        Assert.assertEquals((Object)"Prop1", inEndpoint.getProperties().get("testEndpointProperty"));
    }

    @Test
    public void testTransactionConfig() throws Exception {
        Service apple = muleContext.getRegistry().lookupService("appleComponent2");
        InboundEndpoint inEndpoint = ((ServiceCompositeMessageSource)apple.getMessageSource()).getEndpoint("transactedInboundEndpoint");
        Assert.assertNotNull((Object)inEndpoint);
        Assert.assertEquals((long)1L, (long)((OutboundRouterCollection)apple.getOutboundMessageProcessor()).getRoutes().size());
        Assert.assertNotNull((Object)inEndpoint.getTransactionConfig());
        Assert.assertEquals((long)1L, (long)inEndpoint.getTransactionConfig().getAction());
        Assert.assertTrue((boolean)(inEndpoint.getTransactionConfig().getFactory() instanceof TestTransactionFactory));
        Assert.assertNull((Object)inEndpoint.getTransactionConfig().getConstraint());
        OutboundRouter outRouter = (OutboundRouter)((OutboundRouterCollection)apple.getOutboundMessageProcessor()).getRoutes().get(0);
        MessageProcessor outEndpoint = (MessageProcessor)outRouter.getRoutes().get(0);
        Assert.assertNotNull((Object)outEndpoint);
    }

    @Test
    public void testEnvironmentProperties() {
        Assert.assertEquals((Object)"true", (Object)muleContext.getRegistry().lookupObject("doCompression"));
        Assert.assertEquals((Object)"this was set from the manager properties!", (Object)muleContext.getRegistry().lookupObject("beanProperty1"));
        Assert.assertNotNull((Object)muleContext.getRegistry().lookupObject("OS_Version"));
    }

    @Test
    public void testBindngProxyCreation() {
        Service orange = muleContext.getRegistry().lookupService("orangeComponent");
        Assert.assertNotNull((Object)orange);
        Assert.assertTrue((boolean)(orange.getComponent() instanceof JavaComponent));
        InterfaceBinding r = (InterfaceBinding)((JavaComponent)orange.getComponent()).getInterfaceBindings().get(0);
        Assert.assertNotNull((Object)r);
    }

    @Test
    public void testMuleConfiguration() {
        Assert.assertEquals((long)10L, (long)muleContext.getConfiguration().getDefaultResponseTimeout());
        Assert.assertEquals((long)20L, (long)muleContext.getConfiguration().getDefaultTransactionTimeout());
        Assert.assertEquals((long)30L, (long)muleContext.getConfiguration().getShutdownTimeout());
    }

    @Test
    public void testGlobalInterceptorStack() {
        InterceptorStack interceptorStack = (InterceptorStack)muleContext.getRegistry().lookupObject("testInterceptorStack");
        Assert.assertNotNull((Object)interceptorStack);
        Assert.assertEquals((long)3L, (long)interceptorStack.getInterceptors().size());
        Assert.assertEquals(LoggingInterceptor.class, ((Interceptor)interceptorStack.getInterceptors().get(0)).getClass());
        Assert.assertEquals(TimerInterceptor.class, ((Interceptor)interceptorStack.getInterceptors().get(1)).getClass());
        Assert.assertEquals(LoggingInterceptor.class, ((Interceptor)interceptorStack.getInterceptors().get(2)).getClass());
    }

    @Test
    public void testInterceptors() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        AbstractComponent component = (AbstractComponent)service.getComponent();
        Assert.assertEquals((long)3L, (long)component.getInterceptors().size());
        Assert.assertEquals(LoggingInterceptor.class, ((Interceptor)component.getInterceptors().get(0)).getClass());
        Assert.assertEquals(InterceptorStack.class, ((Interceptor)component.getInterceptors().get(1)).getClass());
        Assert.assertEquals(TimerInterceptor.class, ((Interceptor)component.getInterceptors().get(2)).getClass());
    }
}

