/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.testmodels.services;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.component.simple.EchoService;
import org.mule.api.lifecycle.Disposable;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.testmodels.services.DateService;
import org.mule.tck.testmodels.services.PeopleService;
import org.mule.tck.testmodels.services.Person;
import org.mule.util.StringUtils;

public class TestServiceComponent
extends FunctionalTestComponent
implements EchoService,
DateService,
PeopleService,
Disposable {
    private static final Person[] originalPeople = new Person[]{new Person("Barney", "Rubble"), new Person("Fred", "Flintstone"), new Person("Wilma", "Flintstone")};
    private final Map people = Collections.synchronizedMap(new HashMap());

    public TestServiceComponent() {
        this.people.put("Barney", originalPeople[0]);
        this.people.put("Fred", originalPeople[1]);
        this.people.put("Wilma", originalPeople[2]);
    }

    public String echo(String echo) {
        return echo;
    }

    @Override
    public String getDate() {
        return new Date().toString();
    }

    @Override
    public Person getPerson(String firstName) {
        if (StringUtils.isEmpty((String)firstName)) {
            throw new IllegalArgumentException("Name parameter cannot be null");
        }
        return (Person)this.people.get(firstName);
    }

    @Override
    public Person[] getPeople() {
        return originalPeople;
    }

    @Override
    public void addPerson(Person person) throws Exception {
        if (person == null || person.getFirstName() == null || person.getLastName() == null) {
            throw new IllegalArgumentException("null person, first name or last name");
        }
        if (person.getFirstName().equals("Ross")) {
            throw new Exception("Ross is banned");
        }
        this.people.put(person.getFirstName(), person);
        this.logger.debug((Object)("Added Person: " + person));
    }

    @Override
    public Person addPerson(String firstname, String surname) throws Exception {
        Person p = new Person(firstname, surname);
        this.addPerson(p);
        this.logger.debug((Object)("Added Person: " + p));
        return p;
    }

    @Override
    public void dispose() {
        this.people.clear();
    }
}

