/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.data.sample;

import static org.mule.runtime.api.i18n.I18nMessageFactory.createStaticMessage;

import org.mule.api.annotation.Experimental;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.sdk.api.annotation.MinMuleVersion;

/**
 * {@link Exception} to indicate than an error occurred fetching sample data through a {@link SampleDataProvider}.
 *
 * <b>NOTE:</b> Experimental feature. Backwards compatibility not guaranteed.
 *
 * @since 1.4.0
 */
@Experimental
@MinMuleVersion("4.4")
public class SampleDataException extends MuleException {

  /**
   * Signals an unexpected exception
   */
  public final static String UNKNOWN = "UNKNOWN";

  /**
   * Indicates that the {@link SampleDataProvider} didn't return any information
   */
  public final static String NO_DATA_AVAILABLE = "NO_DATA_AVAILABLE";

  /**
   * Indicates that a connection couldn't be established
   */
  public final static String CONNECTION_FAILURE = "CONNECTION_FAILURE";

  /**
   * Indicates that Sample Data resolution was attempted on a {@link Location} which doesn't exist
   */
  public final static String INVALID_LOCATION = "INVALID_LOCATION";

  /**
   * Indicates that the Sample Data resolution was attempted but the underlying {@link SampleDataProvider} has required parameters
   * which weren't supplied
   */
  public final static String MISSING_REQUIRED_PARAMETERS = "MISSING_REQUIRED_PARAMETERS";

  /**
   * Indicates that Sample Data resolution was attempted on a component which doesn't support that capability
   */
  public final static String NOT_SUPPORTED = "NOT_SUPPORTED";

  /**
   * Indicates that Sample Data resolution was attempted on an unregistered Extension
   */
  public final static String INVALID_TARGET_EXTENSION = "INVALID_TARGET_EXTENSION";

  private final String failureCode;

  public SampleDataException(String message, String failureCode) {
    super(createStaticMessage(message));
    this.failureCode = failureCode;
  }

  public SampleDataException(String message, String failureCode, Throwable cause) {
    super(createStaticMessage(message), cause);
    this.failureCode = failureCode;
  }

  public SampleDataException(I18nMessage message, String failureCode) {
    super(message);
    this.failureCode = failureCode;
  }

  public SampleDataException(I18nMessage message, String failureCode, Throwable cause) {
    super(message, cause);
    this.failureCode = failureCode;
  }

  /**
   * @return The failure code of the error that produced the error
   */
  public String getFailureCode() {
    return failureCode;
  }
}
