/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.documentation;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.tools.generic.CollectionTool;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.Options;
import org.asciidoctor.SafeMode;
import org.mule.extension.maven.documentation.NameUtils;
import org.mule.extension.maven.documentation.types.TypeFlattener;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resolver.ImportTypesStrategy;
import org.mule.runtime.extension.api.dsl.syntax.resolver.SingleExtensionImportTypesStrategy;
import org.mule.runtime.module.extension.api.resources.documentation.ExtensionDescriptionsSerializer;
import org.mule.runtime.module.extension.api.resources.documentation.XmlExtensionDocumentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentationGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentationGenerator.class);
    private static final String TEMPLATE = "documentation/main-template.vm";
    private static final String CSS_FILE_NAME = "styles";
    private static final String CSS_EXTENSION = ".css";
    private static final String ABSENT_CONFIGURATION_NAME = "_ABSENT_CONFIGURATION_ID_";
    private XmlExtensionDocumentation xmlDocumentation;

    public DocumentationGenerator(ExtensionModel extension, File outputDirectory) {
        try {
            ExtensionDescriptionsSerializer deserializer = ExtensionDescriptionsSerializer.SERIALIZER;
            String name = extension.getName().replace(" ", "-").toLowerCase();
            File xmlDocumentationFile = new File(outputDirectory, "classes/META-INF/" + deserializer.getFileName(name));
            LOGGER.debug("Reading extension elements documentation from '{}'", (Object)xmlDocumentationFile);
            String serializedxmlDoc = new String(Files.readAllBytes(xmlDocumentationFile.toPath()));
            this.xmlDocumentation = Objects.requireNonNull(deserializer.deserialize(serializedxmlDoc));
        }
        catch (Exception e) {
            LOGGER.debug("An error occurred while loading the Extension descriptions file", (Throwable)e);
        }
    }

    public String generateAsciidoc(ExtensionModel extension) {
        StringWriter writer = new StringWriter();
        VelocityEngine engine = this.getVelocityEngine();
        VelocityContext context = this.getVelocityContext(extension);
        engine.getTemplate(TEMPLATE).merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    public String generateHtml(String asciidoc) throws MojoExecutionException {
        File css = this.getCssFile();
        Options options = Options.builder().standalone(true).safe(SafeMode.UNSAFE).attributes(Attributes.builder().stylesDir(css.getParent()).styleSheetName(css.getName()).build()).build();
        System.setProperty("jruby.compat.version", "RUBY1_9");
        System.setProperty("jruby.compile.mode", "OFF");
        try (Asciidoctor asciidoctor = Asciidoctor.Factory.create();){
            String string = asciidoctor.convert(asciidoc, options);
            return string;
        }
    }

    private File getCssFile() throws MojoExecutionException {
        try {
            File css = Files.createTempFile(CSS_FILE_NAME, CSS_EXTENSION, new FileAttribute[0]).toFile();
            try (InputStream resourceAsStream = this.getClass().getResourceAsStream("/documentation/styles.css");){
                this.copyStreamToFile(resourceAsStream, css);
            }
            return css;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while obtaining css file: " + e.getMessage(), (Exception)e);
        }
    }

    private VelocityContext getVelocityContext(ExtensionModel extension) {
        VelocityContext context = new VelocityContext();
        DslSyntaxResolver dsl = DslSyntaxResolver.getDefault((ExtensionModel)extension, (ImportTypesStrategy)new SingleExtensionImportTypesStrategy());
        context.put("label", (Object)this.getLabel(extension));
        context.put("dsl", (Object)dsl);
        context.put("sources", this.getSourcesMap(extension));
        context.put("operations", this.getOperationsMap(extension));
        context.put("flattener", (Object)new TypeFlattener(extension, this.xmlDocumentation));
        context.put("nameUtil", NameUtils.class);
        context.put("extension", (Object)extension);
        context.put("absentConfiguration", (Object)ABSENT_CONFIGURATION_NAME);
        context.put("sorter", (Object)new CollectionTool());
        return context;
    }

    private String getLabel(ExtensionModel extension) {
        return extension.getConnectionProviders().isEmpty() ? "Module" : "Connector";
    }

    private Multimap<OperationModel, String> getOperationsMap(ExtensionModel extension) {
        LinkedListMultimap operations = LinkedListMultimap.create();
        extension.getConfigurationModels().forEach(arg_0 -> DocumentationGenerator.lambda$getOperationsMap$1((Multimap)operations, arg_0));
        extension.getOperationModels().forEach(arg_0 -> DocumentationGenerator.lambda$getOperationsMap$2((Multimap)operations, arg_0));
        return operations;
    }

    private Multimap<SourceModel, String> getSourcesMap(ExtensionModel extension) {
        LinkedListMultimap sources = LinkedListMultimap.create();
        extension.getConfigurationModels().forEach(arg_0 -> DocumentationGenerator.lambda$getSourcesMap$4((Multimap)sources, arg_0));
        return sources;
    }

    private VelocityEngine getVelocityEngine() {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loaders", (Object)"classpath");
        ve.setProperty("resource.loader.classpath.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        return ve;
    }

    private void copyStreamToFile(InputStream input, File destination) throws IOException {
        if (destination.exists() && !destination.canWrite()) {
            throw new IOException("Destination file does not exist or cannot be written");
        }
        try (FileOutputStream output = new FileOutputStream(destination);){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
    }

    private static /* synthetic */ void lambda$getSourcesMap$4(Multimap sources, ConfigurationModel config) {
        config.getSourceModels().forEach(source -> sources.put(source, (Object)config.getName()));
    }

    private static /* synthetic */ void lambda$getOperationsMap$2(Multimap operations, OperationModel o) {
        operations.put((Object)o, (Object)ABSENT_CONFIGURATION_NAME);
    }

    private static /* synthetic */ void lambda$getOperationsMap$1(Multimap operations, ConfigurationModel config) {
        config.getOperationModels().forEach(ope -> operations.put(ope, (Object)config.getName()));
    }
}

