/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.documentation.types;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.mule.extension.maven.documentation.types.ObjectTypeUtils;
import org.mule.extension.maven.documentation.types.TypeParserVisitor;
import org.mule.extension.maven.documentation.types.TypeRegister;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.module.extension.api.resources.documentation.XmlExtensionDocumentation;

public class TypeFlattener {
    private final TypeRegister register;
    private final XmlExtensionDocumentation xmlDocumentation;

    public TypeFlattener(ExtensionModel extension, XmlExtensionDocumentation xmlDocumentation) {
        this.register = new TypeRegister(extension);
        this.xmlDocumentation = xmlDocumentation;
    }

    public String flat(ParameterModel param) {
        return this.flat(param.getType());
    }

    public String flat(MetadataType type) {
        TypeParserVisitor visitor = new TypeParserVisitor(this.register.getTypes(), this.register.getSubtypes());
        type.accept((MetadataTypeVisitor)visitor);
        return (String)visitor.holder.get();
    }

    public Map<String, String> getObjectTypes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.register.getTypes().forEach((key, value) -> builder.put((Object)ObjectTypeUtils.getObjectTypeName(value).get(), (Object)ObjectTypeUtils.toAsciidoc(value, this, this.xmlDocumentation)));
        return builder.build();
    }
}

