/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.server;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.server.DefaultMethodRequestMatcher;
import org.mule.runtime.http.api.server.MethodRequestMatcher;

public class MethodRequestMatcherBuilder {
    private final Collection<String> methods = new LinkedList<String>();

    MethodRequestMatcherBuilder() {
    }

    MethodRequestMatcherBuilder(Collection<String> methods) {
        Objects.requireNonNull(methods, "methods attribute should not be null");
        methods.forEach(method -> this.methods.add(method.toUpperCase()));
    }

    public MethodRequestMatcherBuilder add(String method) {
        Objects.requireNonNull(method, "method attribute should not be null");
        this.methods.add(method.toUpperCase());
        return this;
    }

    public MethodRequestMatcherBuilder add(HttpConstants.Method method) {
        Objects.requireNonNull(method, "method attribute should not be null");
        return this.add(method.name());
    }

    public MethodRequestMatcher build() {
        Preconditions.checkArgument((this.methods.size() > 0 ? 1 : 0) != 0, (String)"methods attribute should not be empty");
        return new DefaultMethodRequestMatcher(this.methods);
    }
}

