/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.message;

import java.util.Collection;
import java.util.Optional;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.domain.CaseInsensitiveParameterMap;
import org.mule.runtime.http.api.domain.ParameterMap;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.HttpMessage;

public abstract class HttpMessageBuilder<B extends HttpMessageBuilder, M extends HttpMessage> {
    protected ParameterMap headers = new CaseInsensitiveParameterMap();
    protected HttpEntity entity = new EmptyHttpEntity();

    public B setEntity(HttpEntity entity) {
        Preconditions.checkNotNull((Object)entity, (String)"entity cannot be null, use an EmptyHttpEntity instead");
        this.entity = entity;
        return (B)this;
    }

    public B addHeader(String name, String value) {
        this.headers.put(name, value);
        return (B)this;
    }

    public B removeHeader(String name) {
        this.headers.remove(name);
        return (B)this;
    }

    public Optional<String> getHeaderValue(String name) {
        return Optional.ofNullable(this.headers.get(name));
    }

    public Collection<String> getHeaderValues(String name) {
        return this.headers.getAll(name);
    }

    public abstract M build();
}

