/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.exception.PropertyNotFoundException;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.internal.dsl.DslConstants;

public class ParseTemplateResourceNotPropertyValue
implements Validation {
    private static final String PARSE_TEMPLATE_ELEMENT_NAME = "parse-template";
    private static final String LOCATION_PARAM = "location";
    private static final ComponentIdentifier PARSE_TEMPLATE_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").namespaceUri(DslConstants.CORE_NAMESPACE).name("parse-template").build();
    private final boolean enabled;

    public ParseTemplateResourceNotPropertyValue(boolean enabled) {
        this.enabled = enabled;
    }

    public String getName() {
        return "'parse-template' resources are fixed";
    }

    public String getDescription() {
        return "Template file referenced in 'parse-template' is fixed.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.WARN;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement((Predicate)ComponentAstPredicatesFactory.equalsIdentifier((ComponentIdentifier)PARSE_TEMPLATE_IDENTIFIER)).and(ComponentAstPredicatesFactory.currentElemement(component -> {
            try {
                return component.getParameter("General", LOCATION_PARAM).getValue().getRight() != null;
            }
            catch (PropertyNotFoundException pnfe) {
                if (this.enabled) {
                    return false;
                }
                throw pnfe;
            }
        }));
    }

    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        ComponentParameterAst locationParam = component.getParameter("General", LOCATION_PARAM);
        String locationAttributeRawValue = locationParam.getRawValue();
        if (MuleAstUtils.hasPropertyPlaceholder((String)locationAttributeRawValue)) {
            return Optional.of(ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)locationParam, (Validation)this, (String)("'parse-template' is pointing to '" + locationAttributeRawValue + "' which is resolved with a property and may cause the artifact to have a different structure on different environments.")));
        }
        return Optional.empty();
    }
}

