/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraphProvider;
import org.mule.runtime.ast.graph.api.ComponentAstDependency;
import org.mule.runtime.config.internal.validation.AbstractReferenceParametersStereotypesValidations;
import org.mule.sdk.api.stereotype.MuleStereotypes;

public class ConfigReferenceParametersStereotypesValidations
extends AbstractReferenceParametersStereotypesValidations {
    private final Optional<FeatureFlaggingService> featureFlaggingService;
    private final boolean ignoreParamsWithProperties;
    public static final ComponentIdentifier CACHE_IDENTIFIER = ComponentIdentifier.builder().namespace("ee").name("cache").build();

    public ConfigReferenceParametersStereotypesValidations(Optional<FeatureFlaggingService> featureFlaggingService, boolean ignoreParamsWithProperties, ArtifactAstDependencyGraphProvider artifactAstDependencyGraphProvider) {
        super(artifactAstDependencyGraphProvider);
        this.featureFlaggingService = featureFlaggingService;
        this.ignoreParamsWithProperties = ignoreParamsWithProperties;
    }

    public String getName() {
        return "Config Reference parameters stereotypes";
    }

    public String getDescription() {
        return "Config Reference parameters point to declarations of the appropriate stereotype.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    private Predicate<? super ComponentAstDependency> dependencyNotInDomainFilter(ArtifactAst artifact) {
        if (this.domainFromApp(artifact)) {
            return missing -> ((ArtifactAst)artifact.getParent().get()).topLevelComponentsStream().noneMatch(parentTopLevel -> parentTopLevel.getComponentId().map(id -> id.equals(missing.getName())).orElse(false));
        }
        return missing -> true;
    }

    protected boolean domainFromApp(ArtifactAst artifact) {
        return artifact.getArtifactType().equals((Object)ArtifactType.APPLICATION) && artifact.getParent().map(p -> p.getArtifactType().equals((Object)ArtifactType.DOMAIN)).orElse(false) != false;
    }

    private Predicate<? super ComponentAstDependency> dependencyNotInAppFilter(ArtifactAst artifact) {
        if (this.appFromPolicy(artifact)) {
            return missing -> ((ArtifactAst)artifact.getParent().get()).topLevelComponentsStream().noneMatch(parentTopLevel -> parentTopLevel.getComponentId().map(id -> id.equals(missing.getName())).orElse(false));
        }
        return missing -> true;
    }

    protected boolean appFromPolicy(ArtifactAst artifact) {
        return artifact.getArtifactType().equals((Object)ArtifactType.POLICY) && this.featureFlaggingService.map(ffs -> !ffs.isEnabled((Feature)MuleRuntimeFeature.ENABLE_POLICY_ISOLATION)).orElse(false) != false && artifact.getParent().map(p -> p.getArtifactType().equals((Object)ArtifactType.APPLICATION)).orElse(false) != false;
    }

    @Override
    protected boolean filterComponent(ComponentAstDependency missingDependency) {
        return super.filterComponent(missingDependency) && !this.ignoreParamsWithProperties && !MuleAstUtils.hasPropertyPlaceholder((String)missingDependency.getName());
    }

    @Override
    protected Predicate<? super ComponentAstDependency> filterArtifact(ArtifactAst artifact) {
        Predicate<ComponentAstDependency> configPredicate = missing -> !missing.getComponent().getIdentifier().equals(CACHE_IDENTIFIER) && missing.getAllowedStereotypes().stream().anyMatch(st -> st.isAssignableTo(MuleStereotypes.CONFIG) || st.isAssignableTo(MuleStereotypes.APP_CONFIG));
        return configPredicate.and(this.dependencyNotInDomainFilter(artifact)).and(this.dependencyNotInAppFilter(artifact));
    }
}

