/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class RoundRobinRoutes
implements Validation {
    private static final String ROUND_ROBIN_ELEMENT = "round-robin";
    private static final ComponentIdentifier ROUND_ROBIN_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("round-robin").build();

    public String getName() {
        return "'round-robin' has at least 2 routes";
    }

    public String getDescription() {
        return "'round-robin' has at least 2 routes";
    }

    public Validation.Level getLevel() {
        return Validation.Level.WARN;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(component -> component.getIdentifier().equals(ROUND_ROBIN_IDENTIFIER));
    }

    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        if (component.directChildrenStream().filter(c -> c.getIdentifier().getName().equals("route")).count() < 2L) {
            return Optional.of(ValidationResultItem.create((ComponentAst)component, (Validation)this, (String)"At least 2 routes are required for 'round-robin'."));
        }
        return Optional.empty();
    }
}

