/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.troubleshooting.internal.operations;

import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.troubleshooting.api.ArgumentDefinition;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperation;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationCallback;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationDefinition;
import org.mule.runtime.module.troubleshooting.internal.DefaultArgumentDefinition;
import org.mule.runtime.module.troubleshooting.internal.DefaultTroubleshootingOperationDefinition;

public class EventDumpOperation
implements TroubleshootingOperation {
    public static final String EVENT_DUMP_OPERATION_NAME = "events";
    public static final String EVENT_DUMP_OPERATION_DESCRIPTION = "Collects an EventDump in JSON format";
    public static final String APPLICATION_ARGUMENT_NAME = "application";
    public static final String APPLICATION_ARGUMENT_DESCRIPTION = "Application to collect the event dump from";
    private static final TroubleshootingOperationDefinition definition = EventDumpOperation.createOperationDefinition();
    private final DeploymentService deploymentService;

    public EventDumpOperation(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    @Override
    public TroubleshootingOperationDefinition getDefinition() {
        return definition;
    }

    @Override
    public TroubleshootingOperationCallback getCallback() {
        return arguments -> {
            JSONObject flowStacks = new JSONObject();
            String applicationName = (String)arguments.get(APPLICATION_ARGUMENT_NAME);
            if (applicationName == null) {
                this.addFlowStacksForAllApplications(flowStacks);
            } else {
                Application application = this.deploymentService.findApplication(applicationName);
                EventDumpOperation.addFlowStacksFor(application, flowStacks);
            }
            return flowStacks.toString(2);
        };
    }

    private static void addFlowStacksFor(Application application, JSONObject flowStacks) {
        flowStacks.put(application.getArtifactName(), (Object)EventDumpOperation.getFlowStackEntries(application));
    }

    private void addFlowStacksForAllApplications(JSONObject flowStacks) {
        for (Application application : this.deploymentService.getApplications()) {
            EventDumpOperation.addFlowStacksFor(application, flowStacks);
        }
    }

    private static JSONArray getFlowStackEntries(Application application) {
        EventContextService eventContextService = application.getArtifactContext().getRegistry().lookupByName("_muleEventContextService").map(EventContextService.class::cast).orElseThrow(() -> new IllegalArgumentException(String.format("Could not get EventContextService for application %s.", application.getArtifactName())));
        return EventDumpOperation.flowStackEntriesToJSON(eventContextService.getCurrentlyActiveFlowStacks());
    }

    private static JSONArray flowStackEntriesToJSON(List<EventContextService.FlowStackEntry> flowStackEntries) {
        JSONArray entriesArrayAsJSON = new JSONArray();
        for (EventContextService.FlowStackEntry flowStackEntry : flowStackEntries) {
            entriesArrayAsJSON.put((Object)EventDumpOperation.flowStackEntryToJSON(flowStackEntry));
        }
        return entriesArrayAsJSON;
    }

    private static JSONObject flowStackEntryToJSON(EventContextService.FlowStackEntry flowStackEntry) {
        JSONObject entryAsJSON = new JSONObject();
        entryAsJSON.put("eventId", (Object)flowStackEntry.getEventId());
        entryAsJSON.put("serverId", (Object)flowStackEntry.getServerId());
        entryAsJSON.put("flowCallStack", (Object)EventDumpOperation.flowCallStackToJSON(flowStackEntry.getFlowCallStack()));
        return entryAsJSON;
    }

    private static JSONArray flowCallStackToJSON(FlowCallStack flowCallStack) {
        JSONArray callStackAsJSON = new JSONArray();
        for (FlowStackElement element : flowCallStack.getElements()) {
            callStackAsJSON.put((Object)element.toString());
        }
        return callStackAsJSON;
    }

    private static TroubleshootingOperationDefinition createOperationDefinition() {
        return new DefaultTroubleshootingOperationDefinition(EVENT_DUMP_OPERATION_NAME, EVENT_DUMP_OPERATION_DESCRIPTION, EventDumpOperation.createApplicationArgumentDefinition());
    }

    private static ArgumentDefinition createApplicationArgumentDefinition() {
        return new DefaultArgumentDefinition(APPLICATION_ARGUMENT_NAME, APPLICATION_ARGUMENT_DESCRIPTION, false);
    }
}

