/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.artifact.metadata;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.tooling.internal.artifact.metadata.MetadataKeyResult;
import org.mule.runtime.module.tooling.internal.artifact.params.ExpressionNotSupportedException;
import org.mule.runtime.module.tooling.internal.artifact.params.ParameterSimpleValueExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataKeyDeclarationResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataKeyDeclarationResolver.class);
    private ComponentModel componentModel;
    private ComponentElementDeclaration componentElementDeclaration;
    private ExpressionManager expressionManager;

    public MetadataKeyDeclarationResolver(ComponentModel componentModel, ComponentElementDeclaration componentElementDeclaration) {
        this.componentModel = componentModel;
        this.componentElementDeclaration = componentElementDeclaration;
    }

    public MetadataKeyDeclarationResolver(ComponentModel componentModel, ComponentElementDeclaration componentElementDeclaration, ExpressionManager expressionManager) {
        this(componentModel, componentElementDeclaration);
        this.expressionManager = expressionManager;
    }

    public MetadataKey resolvePartialKey() {
        return this.metadataKeyResult(true).getMetadataKey();
    }

    public MetadataKeyResult resolveKeyResult() {
        return this.metadataKeyResult(false);
    }

    public MetadataKeyResult metadataKeyResult(boolean partialKey) {
        List<MetadataKeyInfo> keyPartModelsInfo = this.getMetadataKeyPartsInfo(this.componentModel);
        if (keyPartModelsInfo.isEmpty()) {
            return new MetadataKeyResult(MetadataKeyBuilder.newKey((String)"").build());
        }
        MetadataKeyBuilder rootMetadataKeyBuilder = null;
        MetadataKeyBuilder metadataKeyBuilder = null;
        Map<String, String> keyPartValues = this.getMetadataKeyPartsValuesFromComponentDeclaration(this.componentElementDeclaration, this.componentModel);
        for (MetadataKeyInfo keyInfo : keyPartModelsInfo) {
            String id = null;
            boolean isNullValue = false;
            if (keyPartValues.containsKey(keyInfo.parameterModel.getName())) {
                id = keyPartValues.get(keyInfo.parameterModel.getName());
                isNullValue = id == null;
            } else {
                if (partialKey || keyInfo.parameterModel.getDefaultValue() == null) break;
                String defaultValue = keyInfo.parameterModel.getDefaultValue().toString();
                if (this.expressionManager != null && MuleExtensionUtils.isExpression((Object)defaultValue)) {
                    try {
                        id = this.expressionManager.evaluate(defaultValue, DataType.STRING).getValue().toString();
                    }
                    catch (ExpressionRuntimeException e) {
                        LOGGER.warn(String.format("Couldn't resolve expression default value for parameter: '%s' which is defined as MetadataKeyPart", keyInfo.parameterModel.getName()), (Throwable)e);
                    }
                } else {
                    id = defaultValue;
                }
            }
            if (id == null && !isNullValue) continue;
            if (metadataKeyBuilder == null) {
                rootMetadataKeyBuilder = metadataKeyBuilder = MetadataKeyBuilder.newKey((String)id).withPartName(keyInfo.parameterModel.getName());
                continue;
            }
            MetadataKeyBuilder metadataKeyChildBuilder = MetadataKeyBuilder.newKey((String)id).withPartName(keyInfo.parameterModel.getName());
            metadataKeyBuilder.withChild(metadataKeyChildBuilder);
            metadataKeyBuilder = metadataKeyChildBuilder;
        }
        List missingPartsInfo = keyPartModelsInfo.stream().filter(ki -> ((MetadataKeyInfo)ki).parameterModel.isRequired() && !keyPartValues.containsKey(((MetadataKeyInfo)ki).parameterModel.getName())).collect(Collectors.toList());
        String partialMessage = null;
        MetadataKey metadataKey = MetadataKeyBuilder.newKey((String)"").build();
        if (!missingPartsInfo.isEmpty()) {
            MetadataKeyInfo firstKeyPartInfo = (MetadataKeyInfo)missingPartsInfo.get(0);
            partialMessage = missingPartsInfo.size() == 1 && firstKeyPartInfo.level == 1 && firstKeyPartInfo.totalLevels == 1 ? String.format("Missing MetadataKey: %s", firstKeyPartInfo.parameterModel.getName()) : String.format("The given MetadataKey does not provide all the required levels. Missing levels: %s", missingPartsInfo.stream().map(ki -> ((MetadataKeyInfo)ki).parameterModel.getName()).collect(Collectors.toList()));
        }
        if (metadataKeyBuilder != null) {
            metadataKey = rootMetadataKeyBuilder.build();
        }
        return new MetadataKeyResult(metadataKey, partialMessage);
    }

    private List<MetadataKeyInfo> getMetadataKeyPartsInfo(ComponentModel componentModel) {
        LinkedList<MetadataKeyInfo> metadataKeyPartsInfo = new LinkedList<MetadataKeyInfo>();
        componentModel.getParameterGroupModels().forEach(pg -> {
            List<ParameterModel> keysInGroup = pg.getParameterModels().stream().filter(pm -> pm.getModelProperty(MetadataKeyPartModelProperty.class).isPresent()).sorted(Comparator.comparingInt(p -> ((MetadataKeyPartModelProperty)p.getModelProperty(MetadataKeyPartModelProperty.class).get()).getOrder())).collect(Collectors.toList());
            keysInGroup.forEach(k -> metadataKeyPartsInfo.add(new MetadataKeyInfo((ParameterModel)k, ((MetadataKeyPartModelProperty)k.getModelProperty(MetadataKeyPartModelProperty.class).get()).getOrder(), keysInGroup.size())));
        });
        return metadataKeyPartsInfo;
    }

    private Map<String, String> getMetadataKeyPartsValuesFromComponentDeclaration(ComponentElementDeclaration componentElementDeclaration, ComponentModel componentModel) {
        HashMap<String, String> parametersMap = new HashMap<String, String>();
        Map parameterGroups = componentModel.getParameterGroupModels().stream().collect(Collectors.toMap(NamedObject::getName, Function.identity()));
        for (ParameterGroupElementDeclaration parameterGroupElement : componentElementDeclaration.getParameterGroups()) {
            String parameterGroupName = parameterGroupElement.getName();
            ParameterGroupModel parameterGroupModel = (ParameterGroupModel)parameterGroups.get(parameterGroupName);
            if (parameterGroupModel == null) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not find parameter group with name: %s in model", (Object[])new Object[]{parameterGroupName}));
            }
            for (ParameterElementDeclaration parameterElement : parameterGroupElement.getParameters()) {
                String parameterName = parameterElement.getName();
                ParameterModel parameterModel = (ParameterModel)parameterGroupModel.getParameter(parameterName).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not find parameter with name: %s in parameter group: %s", (Object[])new Object[]{parameterName, parameterGroupName})));
                if (!parameterModel.getModelProperty(MetadataKeyPartModelProperty.class).isPresent()) continue;
                String value = ParameterSimpleValueExtractor.extractSimpleValue(parameterElement.getValue());
                if (!parameterModel.getExpressionSupport().equals((Object)ExpressionSupport.NOT_SUPPORTED) && MuleExtensionUtils.isExpression((Object)value)) {
                    throw new ExpressionNotSupportedException(String.format("Error resolving value for parameter: '%s' from declaration, it cannot be an EXPRESSION value", parameterName));
                }
                if (parametersMap.containsKey(parameterName)) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Parameter '%s' for MetadataKey is duplicated in declaration, can't decide which one to use", (Object[])new Object[]{parameterName}));
                }
                parametersMap.put(parameterName, value);
            }
        }
        return parametersMap;
    }

    private static class MetadataKeyInfo {
        private int level;
        private int totalLevels;
        private ParameterModel parameterModel;

        private MetadataKeyInfo(ParameterModel parameterModel, int level, int totalLevels) {
            this.parameterModel = parameterModel;
            this.level = level;
            this.totalLevels = totalLevels;
        }
    }
}

