/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.value;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.config.internal.context.lazy.LazyComponentInitializerAdapter;
import org.mule.runtime.config.internal.context.lazy.NoSuchComponentModelException;
import org.mule.runtime.core.internal.util.LocationUtils;

public class LazyValueProviderService
implements ValueProviderService,
Initialisable {
    public static final String NON_LAZY_VALUE_PROVIDER_SERVICE = "_muleNonLazyValueProviderService";
    private final Function<Registry, ValueProviderService> valueProviderServiceSupplier;
    @Inject
    private LazyComponentInitializerAdapter lazyComponentInitializer;
    @Inject
    @Named(value="_muleNonLazyValueProviderService")
    private ValueProviderService providerService;
    @Inject
    private Registry registry;

    public LazyValueProviderService(Function<Registry, ValueProviderService> valueProviderServiceSupplier) {
        this.valueProviderServiceSupplier = valueProviderServiceSupplier;
    }

    public ValueResult getValues(Location location, String providerName) {
        return this.initializeComponent(location).orElseGet(() -> this.providerService.getValues(location, providerName));
    }

    public ValueResult getFieldValues(Location location, String parameter, String targetSelector) {
        return this.initializeComponent(location).orElseGet(() -> this.providerService.getFieldValues(location, parameter, targetSelector));
    }

    private Optional<ValueResult> initializeComponent(Location location) {
        Location locationWithOutConnection = this.locationWithOutConnection(location);
        try {
            this.lazyComponentInitializer.initializeComponent(locationWithOutConnection, false);
        }
        catch (Exception e) {
            Throwable rootException = ExceptionHelper.getRootException((Throwable)e);
            if (rootException instanceof NoSuchComponentModelException) {
                return Optional.of(ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure((Throwable)e).withFailureCode("INVALID_LOCATION").withMessage(String.format("Unable to resolve values. No component was found in the given location [%s]", location)).build()));
            }
            return Optional.of(ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure((Throwable)e).withMessage("Unknown error occurred trying to resolve values. " + e.getMessage()).withFailureCode("UNKNOWN").build()));
        }
        return Optional.empty();
    }

    private Location locationWithOutConnection(Location location) {
        return LocationUtils.isConnection((Location)location) ? LocationUtils.deleteLastPartFromLocation((Location)location) : location;
    }

    public void initialise() throws InitialisationException {
        this.providerService = this.valueProviderServiceSupplier.apply(this.registry);
    }
}

