/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.config;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.sampledata.SampleDataFailure;
import org.mule.runtime.api.sampledata.SampleDataResult;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.app.declaration.api.component.location.Location;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.data.sample.SampleDataService;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.metadata.api.cache.MetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.locator.ComponentLocator;
import org.mule.runtime.metadata.internal.cache.MetadataCacheManager;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.tooling.api.artifact.DeclarationSession;
import org.mule.runtime.module.tooling.internal.artifact.metadata.MetadataComponentExecutor;
import org.mule.runtime.module.tooling.internal.artifact.metadata.MetadataKeysExecutor;
import org.mule.runtime.module.tooling.internal.artifact.sampledata.SampleDataExecutor;
import org.mule.runtime.module.tooling.internal.artifact.value.ValueProviderExecutor;
import org.mule.runtime.module.tooling.internal.metadata.model.DeclarationBasedMetadataCacheIdGenerator;
import org.mule.runtime.module.tooling.internal.utils.ArtifactHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalDeclarationSession
implements DeclarationSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalDeclarationSession.class);
    @Inject
    private ConfigurationComponentLocator componentLocator;
    @Inject
    private ExtensionManager extensionManager;
    @Inject
    private ReflectionCache reflectionCache;
    @Inject
    private MuleContext muleContext;
    @Inject
    private ConnectionManager connectionManager;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    @Named(value="_muleSampleDataService")
    private SampleDataService sampleDataService;
    @Inject
    @Named(value="_metadataCacheManager")
    protected MetadataCacheManager metadataCacheManager;
    private LazyValue<MetadataCacheIdGenerator<ElementDeclaration>> metadataCacheIdGeneratorLazyValue = new LazyValue(() -> {
        DslResolvingContext dslResolvingContext = DslResolvingContext.getDefault((Set)this.extensionManager.getExtensions());
        return new DeclarationBasedMetadataCacheIdGenerator(dslResolvingContext, (ComponentLocator<ElementDeclaration>)((ComponentLocator)location -> artifactDeclaration.findElement(Location.builderFromStringRepresentation((String)location.toString()).build())));
    });
    private final LazyValue<ArtifactHelper> artifactHelperLazyValue = new LazyValue(() -> new ArtifactHelper(this.extensionManager, this.componentLocator, artifactDeclaration));
    private final LazyValue<ValueProviderExecutor> valueProviderExecutorLazyValue = new LazyValue(() -> new ValueProviderExecutor(this.muleContext, this.connectionManager, this.expressionManager, this.reflectionCache, this.artifactHelper()));
    private final LazyValue<MetadataKeysExecutor> metadataKeysExecutorLazyValue = new LazyValue(() -> new MetadataKeysExecutor(this.connectionManager, this.reflectionCache, this.expressionManager, this.artifactHelper(), this.metadataCacheIdGenerator(), this.metadataCacheManager));
    private final LazyValue<MetadataComponentExecutor> metadataComponentExecutorLazyValue = new LazyValue(() -> new MetadataComponentExecutor(this.connectionManager, this.reflectionCache, this.expressionManager, this.artifactHelper(), this.metadataCacheIdGenerator(), this.metadataCacheManager));
    private final LazyValue<SampleDataExecutor> sampleDataExecutorLazyValue = new LazyValue(() -> new SampleDataExecutor(this.muleContext, this.expressionManager, this.sampleDataService, this.reflectionCache, this.artifactHelper()));

    InternalDeclarationSession(ArtifactDeclaration artifactDeclaration) {
    }

    private ArtifactHelper artifactHelper() {
        return (ArtifactHelper)this.artifactHelperLazyValue.get();
    }

    private MetadataCacheIdGenerator<ElementDeclaration> metadataCacheIdGenerator() {
        return (MetadataCacheIdGenerator)this.metadataCacheIdGeneratorLazyValue.get();
    }

    private ValueProviderExecutor valueProviderExecutor() {
        return (ValueProviderExecutor)this.valueProviderExecutorLazyValue.get();
    }

    private MetadataKeysExecutor metadataKeysExecutor() {
        return (MetadataKeysExecutor)this.metadataKeysExecutorLazyValue.get();
    }

    private MetadataComponentExecutor metadataComponentExecutor() {
        return (MetadataComponentExecutor)this.metadataComponentExecutorLazyValue.get();
    }

    private SampleDataExecutor sampleDataExecutor() {
        return (SampleDataExecutor)this.sampleDataExecutorLazyValue.get();
    }

    @Override
    public ConnectionValidationResult testConnection(String configName) {
        return this.artifactHelper().getConfigurationInstance(configName).map(cp -> {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Doing test connection for configName: {}", (Object)configName);
                }
                ConnectionValidationResult connectionValidationResult = this.connectionManager.testConnectivity(cp);
                return connectionValidationResult;
            }
            finally {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Test connection for configName: {} completed", (Object)configName);
                }
            }
        }).orElseGet(() -> ConnectionValidationResult.failure((String)String.format("Could not perform test connection for configuration: '%s'. Connection provider is not defined", configName), (Exception)new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not find connection provider"))));
    }

    @Override
    public ValueResult getValues(ParameterizedElementDeclaration parameterizedElementDeclaration, String providerName) {
        Optional<ExtensionModel> optionalExtensionModel = this.artifactHelper().findExtension((ElementDeclaration)parameterizedElementDeclaration);
        if (!optionalExtensionModel.isPresent()) {
            return ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure().withMessage(this.extensionNotFoundErrorMessage(parameterizedElementDeclaration.getDeclaringExtension())).withFailureCode(FailureCode.COMPONENT_NOT_FOUND.getName()).build());
        }
        Optional optionalParameterizedModel = this.artifactHelper().findModel(optionalExtensionModel.get(), (ElementDeclaration)parameterizedElementDeclaration);
        if (!optionalParameterizedModel.isPresent()) {
            return ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure().withMessage(this.couldNotFindComponentErrorMessage((ElementDeclaration)parameterizedElementDeclaration)).withFailureCode(FailureCode.COMPONENT_NOT_FOUND.getName()).build());
        }
        return this.valueProviderExecutor().resolveValues((ParameterizedModel)optionalParameterizedModel.get(), parameterizedElementDeclaration, providerName);
    }

    @Override
    public ValueResult getFieldValues(ParameterizedElementDeclaration parameterizedElementDeclaration, String providerName, String targetSelector) {
        Optional<ExtensionModel> optionalExtensionModel = this.artifactHelper().findExtension((ElementDeclaration)parameterizedElementDeclaration);
        if (!optionalExtensionModel.isPresent()) {
            return ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure().withMessage(this.extensionNotFoundErrorMessage(parameterizedElementDeclaration.getDeclaringExtension())).withFailureCode(FailureCode.COMPONENT_NOT_FOUND.getName()).build());
        }
        Optional optionalParameterizedModel = this.artifactHelper().findModel(optionalExtensionModel.get(), (ElementDeclaration)parameterizedElementDeclaration);
        if (!optionalParameterizedModel.isPresent()) {
            return ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure().withMessage(this.couldNotFindComponentErrorMessage((ElementDeclaration)parameterizedElementDeclaration)).withFailureCode(FailureCode.COMPONENT_NOT_FOUND.getName()).build());
        }
        return this.valueProviderExecutor().resolveFieldValues((ParameterizedModel)optionalParameterizedModel.get(), parameterizedElementDeclaration, providerName, targetSelector);
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys(ComponentElementDeclaration componentElementDeclaration) {
        Optional<ExtensionModel> optionalExtensionModel = this.artifactHelper().findExtension((ElementDeclaration)componentElementDeclaration);
        if (!optionalExtensionModel.isPresent()) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(this.extensionNotFoundErrorMessage(componentElementDeclaration.getDeclaringExtension())).withFailureCode(FailureCode.COMPONENT_NOT_FOUND).onKeys()});
        }
        Optional<? extends ComponentModel> optionalComponentModel = this.artifactHelper().findComponentModel(optionalExtensionModel.get(), componentElementDeclaration);
        if (!optionalComponentModel.isPresent()) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(this.couldNotFindComponentErrorMessage((ElementDeclaration)componentElementDeclaration)).withFailureCode(FailureCode.COMPONENT_NOT_FOUND).onKeys()});
        }
        return this.metadataKeysExecutor().resolveMetadataKeys(optionalComponentModel.get(), componentElementDeclaration);
    }

    @Override
    public MetadataResult<ComponentMetadataTypesDescriptor> resolveComponentMetadata(ComponentElementDeclaration componentElementDeclaration) {
        Optional<ExtensionModel> optionalExtensionModel = this.artifactHelper().findExtension((ElementDeclaration)componentElementDeclaration);
        if (!optionalExtensionModel.isPresent()) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(this.extensionNotFoundErrorMessage(componentElementDeclaration.getDeclaringExtension())).withFailureCode(FailureCode.COMPONENT_NOT_FOUND).onComponent()});
        }
        Optional<? extends ComponentModel> optionalComponentModel = this.artifactHelper().findComponentModel(optionalExtensionModel.get(), componentElementDeclaration);
        if (!optionalComponentModel.isPresent()) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(this.couldNotFindComponentErrorMessage((ElementDeclaration)componentElementDeclaration)).withFailureCode(FailureCode.COMPONENT_NOT_FOUND).onComponent()});
        }
        return this.metadataComponentExecutor().resolveComponentMetadata(optionalComponentModel.get(), componentElementDeclaration);
    }

    @Override
    public void disposeMetadataCache(ComponentElementDeclaration componentElementDeclaration) {
        this.metadataComponentExecutor().disposeMetadataCache(componentElementDeclaration);
    }

    @Override
    public SampleDataResult getSampleData(ComponentElementDeclaration componentElementDeclaration) {
        Optional<ExtensionModel> optionalExtensionModel = this.artifactHelper().findExtension((ElementDeclaration)componentElementDeclaration);
        if (!optionalExtensionModel.isPresent()) {
            return SampleDataResult.resultFrom((SampleDataFailure)SampleDataFailure.Builder.newFailure().withMessage(this.extensionNotFoundErrorMessage(componentElementDeclaration.getDeclaringExtension())).withFailureCode(FailureCode.COMPONENT_NOT_FOUND.getName()).build());
        }
        Optional<? extends ComponentModel> optionalComponentModel = this.artifactHelper().findComponentModel(optionalExtensionModel.get(), componentElementDeclaration);
        if (!optionalComponentModel.isPresent()) {
            return SampleDataResult.resultFrom((SampleDataFailure)SampleDataFailure.Builder.newFailure().withMessage(this.couldNotFindComponentErrorMessage((ElementDeclaration)componentElementDeclaration)).withFailureCode(FailureCode.COMPONENT_NOT_FOUND.getName()).build());
        }
        return this.sampleDataExecutor().getSampleData(optionalComponentModel.get(), componentElementDeclaration);
    }

    private String couldNotFindComponentErrorMessage(ElementDeclaration declaration) {
        return String.format("Could not find component: '%s:%s'", declaration.getDeclaringExtension(), declaration.getName());
    }

    private String extensionNotFoundErrorMessage(String declaringExtension) {
        return String.format("ElementDeclaration is defined for extension: '%s' which is not part of the context: '%s'", declaringExtension, this.artifactHelper().getExtensions());
    }

    @Override
    public void dispose() {
    }
}

