/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tls.internal.revocation;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.ManagerFactoryParameters;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.privileged.security.RevocationCheck;

public class CrlFile
implements RevocationCheck {
    private String path;

    public void setPath(String path) {
        this.path = path;
    }

    public ManagerFactoryParameters configFor(KeyStore trustStore, Set<TrustAnchor> defaultTrustAnchors) {
        Preconditions.checkArgument((this.path != null ? 1 : 0) != 0, (String)"tls:crl-file requires the 'path' attribute");
        Preconditions.checkArgument((trustStore != null ? 1 : 0) != 0, (String)"tls:crl-file requires a trust store");
        try {
            Set<TrustAnchor> trustAnchors = CrlFile.getTrustAnchorsFromKeyStore(trustStore);
            PKIXBuilderParameters pbParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)new X509CertSelector());
            pbParams.setRevocationEnabled(true);
            Collection<? extends CRL> crls = this.loadCRL(this.path);
            if (crls != null && !crls.isEmpty()) {
                pbParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crls)));
            }
            return new CertPathTrustManagerParameters(pbParams);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends CRL> loadCRL(String crlPath) throws CertificateException, IOException, CRLException {
        Collection<? extends CRL> crlList = null;
        if (crlPath != null) {
            try (InputStream in = null;){
                in = IOUtils.getResourceAsStream((String)crlPath, this.getClass());
                crlList = CertificateFactory.getInstance("X.509").generateCRLs(in);
            }
        }
        return crlList;
    }

    private static Set<TrustAnchor> getTrustAnchorsFromKeyStore(KeyStore keyStore) throws GeneralSecurityException {
        Enumeration<String> aliases = keyStore.aliases();
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isCertificateEntry(alias)) continue;
            trustAnchors.add(new TrustAnchor((X509Certificate)keyStore.getCertificate(alias), null));
        }
        return trustAnchors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrlFile crlFile = (CrlFile)o;
        return this.path != null ? this.path.equals(crlFile.path) : crlFile.path == null;
    }

    public int hashCode() {
        return this.path != null ? this.path.hashCode() : 0;
    }
}

