/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tls.internal;

import java.io.IOException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.module.tls.internal.DefaultTlsContextFactory;

public class DefaultTlsContextFactoryBuilder
implements TlsContextFactoryBuilder {
    private TlsContextFactory defaultTlsContextFactory;
    private DefaultTlsContextFactory tlsContextFactory = new DefaultTlsContextFactory();
    private String trustStorePath;
    private String keyStorePath;

    public DefaultTlsContextFactoryBuilder(TlsContextFactory defaultTlsContextFactory) {
        this.defaultTlsContextFactory = defaultTlsContextFactory;
    }

    public TlsContextFactoryBuilder setName(String name) {
        this.tlsContextFactory.setName(name);
        return this;
    }

    public TlsContextFactoryBuilder setEnabledProtocols(String protocols) {
        this.tlsContextFactory.setEnabledProtocols(protocols);
        return this;
    }

    public TlsContextFactoryBuilder setEnabledCipherSuites(String cipherSuites) {
        this.tlsContextFactory.setEnabledCipherSuites(cipherSuites);
        return this;
    }

    public TlsContextFactoryBuilder setTrustStorePath(String path) {
        this.trustStorePath = path;
        return this;
    }

    public TlsContextFactoryBuilder setTrustStorePassword(String password) {
        this.tlsContextFactory.setTrustStorePassword(password);
        return this;
    }

    public TlsContextFactoryBuilder setTrustStoreType(String type) {
        this.tlsContextFactory.setTrustStoreType(type);
        return this;
    }

    public TlsContextFactoryBuilder setInsecureTrustStore(boolean insecure) {
        this.tlsContextFactory.setTrustStoreInsecure(insecure);
        return this;
    }

    public TlsContextFactoryBuilder setTrustStoreAlgorithm(String algorithm) {
        this.tlsContextFactory.setTrustManagerAlgorithm(algorithm);
        return this;
    }

    public TlsContextFactoryBuilder setKeyStorePath(String path) {
        this.keyStorePath = path;
        return this;
    }

    public TlsContextFactoryBuilder setKeyStorePassword(String password) {
        this.tlsContextFactory.setKeyStorePassword(password);
        return this;
    }

    public TlsContextFactoryBuilder setKeyAlias(String alias) {
        this.tlsContextFactory.setKeyAlias(alias);
        return this;
    }

    public TlsContextFactoryBuilder setKeyPassword(String password) {
        this.tlsContextFactory.setKeyPassword(password);
        return this;
    }

    public TlsContextFactoryBuilder setKeyStoreType(String type) {
        this.tlsContextFactory.setKeyStoreType(type);
        return this;
    }

    public TlsContextFactoryBuilder setKeyStoreAlgorithm(String algorithm) {
        this.tlsContextFactory.setKeyManagerAlgorithm(algorithm);
        return this;
    }

    public TlsContextFactory build() throws CreateException {
        try {
            if (this.trustStorePath != null) {
                this.tlsContextFactory.setTrustStorePath(this.trustStorePath);
            }
            if (this.keyStorePath != null) {
                this.tlsContextFactory.setKeyStorePath(this.keyStorePath);
            }
            this.tlsContextFactory.initialise();
        }
        catch (IOException e) {
            throw new CreateException(I18nMessageFactory.createStaticMessage((String)e.getMessage()), (Throwable)e, (Object)this.tlsContextFactory);
        }
        catch (InitialisationException e) {
            throw new CreateException(e.getI18nMessage(), (Throwable)e, (Object)this.tlsContextFactory);
        }
        return this.tlsContextFactory;
    }

    public TlsContextFactory buildDefault() {
        return this.defaultTlsContextFactory;
    }
}

