/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.ioc.ConfigurableObjectProvider;
import org.mule.runtime.api.ioc.ObjectProvider;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.config.api.dsl.processor.AbstractAttributeDefinitionVisitor;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CreateComponentBeanDefinitionRequest;
import org.mule.runtime.config.internal.factories.ConstantFactoryBean;
import org.mule.runtime.dsl.api.component.AttributeDefinitionVisitor;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.SetterAttributeDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

class EagerObjectCreator
extends BeanDefinitionCreator<CreateComponentBeanDefinitionRequest> {
    private final ImmutableSet<Class<?>> earlyCreationObjectTypes = ImmutableSet.builder().add(ObjectProvider.class).build();

    EagerObjectCreator() {
    }

    @Override
    boolean handleRequest(Map<ComponentAst, SpringComponentModel> springComponentModels, CreateComponentBeanDefinitionRequest createBeanDefinitionRequest) {
        Class type = createBeanDefinitionRequest.getSpringComponentModel().getType();
        if (type == null) {
            return false;
        }
        Optional<Class> foundClass = this.earlyCreationObjectTypes.stream().filter(clazz -> clazz.isAssignableFrom(type)).findAny();
        return foundClass.map(clazz -> {
            ConfigurableObjectProvider instance;
            ComponentBuildingDefinition componentBuildingDefinition = createBeanDefinitionRequest.getComponentBuildingDefinition();
            try {
                instance = (ConfigurableObjectProvider)type.newInstance();
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not create an instance of '%s' using default constructor. Early created object must have a default constructor", (Object[])new Object[]{type.getName()}));
            }
            final ComponentAst component = createBeanDefinitionRequest.getComponent();
            componentBuildingDefinition.getSetterParameterDefinitions().forEach(attributeDefinition -> {
                final SetterAttributeDefinition setterAttributeDefinition = (SetterAttributeDefinition)attributeDefinition;
                setterAttributeDefinition.getAttributeDefinition().accept((AttributeDefinitionVisitor)new AbstractAttributeDefinitionVisitor(){

                    @Override
                    public void onUndefinedSimpleParameters() {
                        Map parameters = component.getModel(ParameterizedModel.class).map(pm -> component.getParameters().stream().filter(param -> param.getResolvedRawValue() != null).collect(Collectors.toMap(param -> param.getModel().getName(), ComponentParameterAst::getResolvedRawValue))).orElse(null);
                        String attributeName = setterAttributeDefinition.getAttributeName();
                        try {
                            BeanUtils.setProperty((Object)instance, (String)attributeName, (Object)parameters);
                        }
                        catch (Exception e) {
                            throw new MuleRuntimeException((Throwable)e);
                        }
                    }

                    @Override
                    protected void doOnOperation(String operation) {
                        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Attribute definition with operation '%s' is not supported for earlyCreationObjects", operation)));
                    }
                });
            });
            createBeanDefinitionRequest.getSpringComponentModel().setObjectInstance(instance);
            createBeanDefinitionRequest.getSpringComponentModel().setBeanDefinition((BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(ConstantFactoryBean.class).addConstructorArgValue((Object)instance).getBeanDefinition());
            return true;
        }).orElse(false);
    }
}

