/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.CommonComponentBeanDefinitionCreator;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;

public class ComponentModelHelper {
    public static boolean isAnnotatedObject(SpringComponentModel springComponentModel) {
        return ComponentModelHelper.isOfType(springComponentModel, Component.class) || ComponentModelHelper.isOfType(springComponentModel, ValueResolver.class);
    }

    private static boolean isOfType(SpringComponentModel springComponentModel, Class type) {
        Class componentModelType = springComponentModel.getType();
        if (componentModelType == null) {
            return false;
        }
        return CommonComponentBeanDefinitionCreator.areMatchingTypes(type, componentModelType);
    }

    public static void addAnnotation(QName annotationKey, Object annotationValue, SpringComponentModel springComponentModel) {
        if (!ComponentModelHelper.isAnnotatedObject(springComponentModel) && !springComponentModel.getComponent().getIdentifier().getName().equals("flow-ref")) {
            return;
        }
        BeanDefinition beanDefinition = springComponentModel.getBeanDefinition();
        if (beanDefinition == null) {
            return;
        }
        ComponentModelHelper.updateAnnotationValue(annotationKey, annotationValue, beanDefinition);
    }

    public static void updateAnnotationValue(QName annotationKey, Object annotationValue, BeanDefinition beanDefinition) {
        Map<QName, Object> annotations;
        PropertyValue propertyValue = beanDefinition.getPropertyValues().getPropertyValue("annotations");
        if (propertyValue == null) {
            annotations = new HashMap();
            propertyValue = new PropertyValue("annotations", annotations);
            beanDefinition.getPropertyValues().addPropertyValue(propertyValue);
        } else {
            annotations = (Map)propertyValue.getValue();
        }
        annotations.put(annotationKey, annotationValue);
    }
}

