/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.el;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleProperties;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.internal.el.DefaultBindingContextBuilder;
import org.mule.runtime.core.internal.el.DefaultExpressionManager;
import org.mule.runtime.core.internal.el.ExpressionLanguageAdaptorHandler;
import org.mule.runtime.core.internal.el.ExtendedExpressionLanguageAdaptor;
import org.mule.runtime.core.internal.execution.ClassLoaderInjectorInvocationHandler;
import org.mule.runtime.core.privileged.el.GlobalBindingContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultExpressionManagerFactoryBean
implements FactoryBean<ExtendedExpressionManager> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExpressionManagerFactoryBean.class);
    @Inject
    private MuleContext muleContext;
    @Inject
    @Named(value="_muleDwExpressionLanguageAdapter")
    private ExtendedExpressionLanguageAdaptor dwExpressionLanguage;
    @Inject
    @Named(value="_compatibilityPluginInstalled")
    private Optional<Object> compatibilityPluginInstalled;
    @Inject
    @Named(value="_muleExpressionLanguage")
    private ExtendedExpressionLanguageAdaptor mvelExpressionLanguage;
    @Inject
    @Autowired(required=false)
    private final List<GlobalBindingContextProvider> globalBindingContextProviders = Collections.emptyList();

    public ExtendedExpressionManager getObject() throws Exception {
        DefaultExpressionManager delegate = this.createBaseObject();
        ExtendedExpressionLanguageAdaptor expressionLanguage = this.createExpressionLanguage();
        this.populateBindings(expressionLanguage);
        delegate.setExpressionLanguage(expressionLanguage);
        boolean melDefault = MuleProperties.isMelDefault() || this.dwExpressionLanguage == null && this.compatibilityPluginInstalled.isPresent();
        delegate.setMelDefault(melDefault);
        if (melDefault) {
            LOGGER.warn("Using MEL as the default expression language.");
        }
        this.muleContext.getInjector().inject((Object)delegate);
        return (ExtendedExpressionManager)ClassLoaderInjectorInvocationHandler.createClassLoaderInjectorInvocationHandler((Object)delegate, (ClassLoader)this.muleContext.getExecutionClassLoader());
    }

    protected void populateBindings(ExtendedExpressionLanguageAdaptor expressionLanguage) {
        BindingContext.Builder contextBuilder = BindingContext.builder();
        this.globalBindingContextProviders.stream().map(GlobalBindingContextProvider::getBindingContext).forEach(arg_0 -> ((BindingContext.Builder)contextBuilder).addAll(arg_0));
        expressionLanguage.addGlobalBindings(contextBuilder instanceof DefaultBindingContextBuilder ? ((DefaultBindingContextBuilder)contextBuilder).flattenAndBuild() : contextBuilder.build());
    }

    protected DefaultExpressionManager createBaseObject() {
        return new DefaultExpressionManager();
    }

    private ExtendedExpressionLanguageAdaptor createExpressionLanguage() {
        if (MuleProperties.isMelDefault() || this.compatibilityPluginInstalled.isPresent()) {
            ExpressionLanguageAdaptorHandler exprLangAdaptorHandler = this.dwExpressionLanguage != null ? new ExpressionLanguageAdaptorHandler(this.dwExpressionLanguage, this.mvelExpressionLanguage) : this.mvelExpressionLanguage;
            return exprLangAdaptorHandler;
        }
        if (this.dwExpressionLanguage == null) {
            throw new IllegalStateException("No expression language installed");
        }
        return this.dwExpressionLanguage;
    }

    public Class<?> getObjectType() {
        return ExtendedExpressionManager.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

