/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.error.matcher.ErrorTypeMatcher;
import org.mule.runtime.api.message.error.matcher.ErrorTypeMatcherUtils;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.internal.exception.EnrichedErrorMapping;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrichedErrorMappingsFactoryBean
extends AbstractComponentFactory<EnrichedErrorMapping> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrichedErrorMappingsFactoryBean.class);
    public static final String CORE_ERROR_NS = "mule".toUpperCase();
    @Inject
    private ErrorTypeRepository errorTypeRepository;
    private String source;
    private String target;

    public EnrichedErrorMapping doGetObject() throws Exception {
        ErrorTypeMatcher errorTypeMatcher;
        try {
            errorTypeMatcher = this.source != null ? ErrorTypeMatcherUtils.createErrorTypeMatcher((ErrorTypeRepository)this.errorTypeRepository, (String)this.source) : ErrorTypeMatcherUtils.createErrorTypeMatcher((ErrorType)((ErrorType)this.errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Handleable.ANY).get()));
        }
        catch (IllegalArgumentException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        ErrorType targetValue = this.resolveErrorType(this.target);
        return new EnrichedErrorMapping(errorTypeMatcher, targetValue);
    }

    private ErrorType resolveErrorType(String representation) {
        ComponentIdentifier errorIdentifier = EnrichedErrorMappingsFactoryBean.parserErrorType(representation);
        Optional lookupErrorType = this.errorTypeRepository.lookupErrorType(errorIdentifier);
        if (CORE_ERROR_NS.equals(errorIdentifier.getNamespace())) {
            return (ErrorType)lookupErrorType.orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("There's no MULE error named '%s'.", errorIdentifier.getName()))));
        }
        if (lookupErrorType.isPresent()) {
            return (ErrorType)lookupErrorType.get();
        }
        if (Boolean.getBoolean("mule.errorTypes.lax")) {
            LOGGER.warn("Could not find synthetic error '{}' in registry", (Object)errorIdentifier);
            return this.errorTypeRepository.addErrorType(errorIdentifier, this.errorTypeRepository.getAnyErrorType());
        }
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not find synthetic error '%s' in registry", (Object[])new Object[]{errorIdentifier}));
    }

    public static ComponentIdentifier parserErrorType(String representation) {
        String identifier;
        String namespace;
        int separator = representation.indexOf(58);
        if (separator > 0) {
            namespace = representation.substring(0, separator).toUpperCase();
            identifier = representation.substring(separator + 1).toUpperCase();
        } else {
            namespace = CORE_ERROR_NS;
            identifier = representation.toUpperCase();
        }
        return ComponentIdentifier.builder().namespace(namespace).name(identifier).build();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }
}

