/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.config.internal.context.BaseSpringMuleContextServiceConfigurator;
import org.mule.runtime.config.internal.context.MuleContextPostProcessor;
import org.mule.runtime.config.internal.context.ObjectProviderAwareBeanFactory;
import org.mule.runtime.config.internal.model.dsl.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.model.dsl.config.PropertiesResolverConfigurationProperties;
import org.mule.runtime.config.internal.model.properties.PropertiesHierarchyCreationUtils;
import org.mule.runtime.config.internal.processor.MuleInjectorProcessor;
import org.mule.runtime.config.internal.registry.OptionalObjectsController;
import org.mule.runtime.config.privileged.spring.ByteBuddySpringCacheInstrumentator;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.registry.DefaultRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistryHelper;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.properties.api.ResourceProvider;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.ContextAnnotationAutowireCandidateResolver;
import org.springframework.context.support.AbstractRefreshableConfigApplicationContext;

public class BaseMuleArtifactContext
extends AbstractRefreshableConfigApplicationContext {
    private final DefaultRegistry serviceDiscoverer;
    private final MuleContextWithRegistry muleContext;
    private final Registry originalRegistry;
    private final ArtifactType artifactType;
    private final OptionalObjectsController optionalObjectsController;
    private final PropertiesResolverConfigurationProperties configurationProperties;
    private final boolean enableLazyInit;

    public BaseMuleArtifactContext(MuleContext muleContext, OptionalObjectsController optionalObjectsController, Optional<ConfigurationProperties> parentConfigurationProperties, Map<String, String> artifactProperties, ArtifactType artifactType, boolean enableLazyInit) {
        this.muleContext = (MuleContextWithRegistry)muleContext;
        this.originalRegistry = ((MuleRegistryHelper)((MuleContextWithRegistry)muleContext).getRegistry()).getDelegate();
        this.serviceDiscoverer = new DefaultRegistry(muleContext);
        this.artifactType = artifactType;
        this.optionalObjectsController = optionalObjectsController;
        this.configurationProperties = PropertiesHierarchyCreationUtils.createConfigurationAttributeResolver(parentConfigurationProperties, artifactProperties, (ResourceProvider)new ClassLoaderResourceProvider(muleContext.getExecutionClassLoader()));
        this.enableLazyInit = enableLazyInit;
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        beanFactory.setBeanExpressionResolver(null);
        this.registerInjectorProcessor(beanFactory);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new MuleContextPostProcessor((MuleContext)this.muleContext));
        beanFactory.registerSingleton("_muleContext", (Object)this.muleContext);
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
        super.customizeBeanFactory(beanFactory);
        new BaseSpringMuleContextServiceConfigurator((MuleContext)this.muleContext, (ConfigurationProperties)this.configurationProperties, this.artifactType, this.optionalObjectsController, (BeanDefinitionRegistry)beanFactory, (org.mule.runtime.api.artifact.Registry)this.serviceDiscoverer, this.originalRegistry, this.enableLazyInit).createArtifactServices();
    }

    private void registerInjectorProcessor(ConfigurableListableBeanFactory beanFactory) {
        MuleInjectorProcessor muleInjectorProcessor = new MuleInjectorProcessor();
        muleInjectorProcessor.setBeanFactory((BeanFactory)beanFactory);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)muleInjectorProcessor);
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        ObjectProviderAwareBeanFactory beanFactory = new ObjectProviderAwareBeanFactory(this.getInternalParentBeanFactory());
        beanFactory.setAutowireCandidateResolver((AutowireCandidateResolver)new ContextAnnotationAutowireCandidateResolver());
        return beanFactory;
    }

    public String toString() {
        return String.format("%s: %s (base)", ((Object)((Object)this)).getClass().getName(), this.muleContext.getConfiguration().getId());
    }

    static {
        ByteBuddySpringCacheInstrumentator.instrumentSpringCachesForCleanup();
    }
}

