/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.MetadataTypeAdapter;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ComponentAstBasedElementModelFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentAstBasedElementModelFactory.class);
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    ComponentAstBasedElementModelFactory() {
    }

    public <T> Optional<DslElementModel<T>> create(ComponentAst configuration) {
        return configuration.getModel(ParameterizedModel.class).flatMap(model -> Optional.of(this.createElementModel(model, (DslElementSyntax)configuration.getGenerationInformation().getSyntax().get(), configuration).build()));
    }

    private Optional<DslElementModel.Builder<ObjectType>> resolveBasedOnType(ObjectType type, ComponentAst configuration) {
        return configuration.getGenerationInformation().getSyntax().flatMap(typeDsl -> {
            Optional<ComponentIdentifier> elementIdentifier = this.getIdentifier((DslElementSyntax)typeDsl);
            if (elementIdentifier.isPresent() && configuration.getModel(MetadataTypeAdapter.class).map(mtma -> mtma.isWrapperFor((MetadataType)type)).orElse(false).booleanValue()) {
                DslElementModel.Builder<ObjectType> typeBuilder = DslElementModel.builder().withModel(type).withDsl((DslElementSyntax)typeDsl).withConfig(configuration);
                this.enrichElementModel((ParameterizedModel)((ParameterizedModel)configuration.getModel(ParameterizedModel.class).get()), (DslElementSyntax)typeDsl, configuration, typeBuilder);
                return Optional.of(typeBuilder);
            }
            return Optional.empty();
        });
    }

    private Multimap<ComponentIdentifier, ComponentAst> getNestedComponents(ComponentAst configuration) {
        ArrayListMultimap result = ArrayListMultimap.create();
        configuration.directChildrenStream().forEach(arg_0 -> ComponentAstBasedElementModelFactory.lambda$getNestedComponents$3((Multimap)result, arg_0));
        return result;
    }

    private MetadataTypeVisitor getComponentChildVisitor(final DslElementModel.Builder typeBuilder, final ComponentAst configuration, final MetadataType model, final String groupName, final String name, final DslElementSyntax modelDsl, final Optional<String> defaultValue) {
        return new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                DslElementModel.Builder<MetadataType> elementBuilder = DslElementModel.builder().withModel(model).withDsl(modelDsl);
                Optional identifier = ComponentAstBasedElementModelFactory.this.getIdentifier(modelDsl);
                ComponentParameterAst param = configuration.getParameter(groupName, name);
                if (param != null) {
                    String value = param.getRawValue();
                    LOGGER.trace("getComponentChildVisitor#defaultVisit: '{}': '{}'", (Object)identifier, (Object)value);
                    if (!StringUtils.isBlank((CharSequence)value)) {
                        typeBuilder.containing(elementBuilder.withValue(value).build());
                    }
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                Optional identifier = ComponentAstBasedElementModelFactory.this.getIdentifier(modelDsl);
                if (!identifier.isPresent()) {
                    LOGGER.trace("getComponentChildVisitor#visitArrayType: noIdentifier");
                    this.visitNoIdentifier(typeBuilder, model, modelDsl, defaultValue);
                    return;
                }
                LOGGER.trace("getComponentChildVisitor#visitArrayType: '{}'", identifier.get());
                ComponentAst fieldComponent = ComponentAstBasedElementModelFactory.this.getSingleComponentConfiguration((Multimap<ComponentIdentifier, ComponentAst>)ComponentAstBasedElementModelFactory.this.getNestedComponents(configuration), identifier);
                if (fieldComponent != null) {
                    DslElementModel.Builder<MetadataType> list = DslElementModel.builder().withModel(model).withDsl((DslElementSyntax)fieldComponent.getGenerationInformation().getSyntax().get()).withConfig(fieldComponent);
                    modelDsl.getGeneric(arrayType.getType()).ifPresent(itemdsl -> {
                        ComponentIdentifier itemIdentifier = (ComponentIdentifier)ComponentAstBasedElementModelFactory.this.getIdentifier(itemdsl).get();
                        fieldComponent.directChildrenStream().filter(c -> c.getIdentifier().equals(itemIdentifier)).forEach(c -> ComponentAstBasedElementModelFactory.this.getComponentChildVisitor(list, c, arrayType.getType(), "General", "value", itemdsl, defaultValue));
                    });
                    typeBuilder.containing(list.build());
                }
            }

            public void visitObject(ObjectType objectType) {
                String value;
                Optional identifier = ComponentAstBasedElementModelFactory.this.getIdentifier(modelDsl);
                if (!identifier.isPresent()) {
                    LOGGER.trace("getComponentChildVisitor#visitObject: noIdentifier");
                    this.visitNoIdentifier(typeBuilder, model, modelDsl, defaultValue);
                } else {
                    LOGGER.trace("getComponentChildVisitor#visitObject: '{}'", identifier.get());
                }
                ComponentAst fieldComponent = (ComponentAst)configuration.getParameter("General", "value").getValue().getRight();
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                    LOGGER.trace("getComponentChildVisitor#visitObject: '{}' -> isMap", identifier.orElse(null));
                    typeBuilder.containing(ComponentAstBasedElementModelFactory.this.createMapElement(objectType, modelDsl, fieldComponent));
                    return;
                }
                ComponentParameterAst param = configuration.getParameter(groupName, name);
                String string = value = param != null ? param.getRawValue() : null;
                if (!StringUtils.isBlank((CharSequence)value)) {
                    typeBuilder.containing(DslElementModel.builder().withModel(model).withDsl(modelDsl).withValue(value).build());
                } else {
                    ComponentAstBasedElementModelFactory.this.resolveBasedOnType(objectType, fieldComponent).ifPresent(elementBuilder -> typeBuilder.containing(elementBuilder.withDsl(modelDsl).build()));
                }
            }

            private void visitNoIdentifier(DslElementModel.Builder typeBuilder2, MetadataType model2, DslElementSyntax modelDsl2, Optional<String> defaultValue2) {
                defaultValue2.ifPresent(s -> typeBuilder2.containing(DslElementModel.builder().withModel(model2).withDsl(modelDsl2).withValue((String)defaultValue2.get()).isExplicitInDsl(false).build()));
            }
        };
    }

    private DslElementModel createMapElement(ObjectType objectType, DslElementSyntax modelDsl, ComponentAst configuration) {
        DslElementModel.Builder<ObjectType> mapBuilder = DslElementModel.builder().withModel(objectType).withDsl((DslElementSyntax)configuration.getGenerationInformation().getSyntax().get()).withConfig(configuration);
        if (configuration != null && configuration.directChildrenStream().count() > 0L) {
            this.populateMapEntries(objectType, modelDsl, mapBuilder, configuration);
        }
        return mapBuilder.build();
    }

    private void populateMapEntries(ObjectType objectType, DslElementSyntax modelDsl, DslElementModel.Builder mapBuilder, ComponentAst mapConfig) {
        this.populateMapEntries(objectType, modelDsl, mapBuilder, mapConfig.directChildrenStream().collect(Collectors.toList()));
    }

    private void populateMapEntries(ObjectType objectType, DslElementSyntax modelDsl, DslElementModel.Builder mapBuilder, Collection<ComponentAst> mapEntriesConfigs) {
        mapEntriesConfigs.forEach(entryConfig -> {
            MetadataType entryType = (MetadataType)objectType.getOpenRestriction().get();
            modelDsl.getGeneric(entryType).ifPresent(entryDsl -> {
                DslElementModel.Builder<MetadataType> entry = DslElementModel.builder().withModel(entryType).withConfig((ComponentAst)entryConfig).withDsl((DslElementSyntax)entryConfig.getGenerationInformation().getSyntax().get());
                entry.containing(DslElementModel.builder().withModel(this.typeLoader.load(String.class)).withValue(entryConfig.getParameter("General", "key").getRawValue()).withDsl((DslElementSyntax)entryDsl.getAttribute("key").get()).build());
                String value = entryConfig.getParameter("General", "value").getRawValue();
                if (StringUtils.isBlank((CharSequence)value)) {
                    entryType.accept(this.getComponentChildVisitor(entry, (ComponentAst)entryConfig, entryType, "General", "value", (DslElementSyntax)entryDsl.getAttribute("value").get(), Optional.empty()));
                } else {
                    entry.containing(DslElementModel.builder().withModel(this.typeLoader.load(String.class)).withValue(value).withDsl((DslElementSyntax)entryDsl.getAttribute("value").get()).build());
                }
                mapBuilder.containing(entry.build());
            });
        });
    }

    private <T extends ParameterizedModel> DslElementModel.Builder<T> createElementModel(T model, DslElementSyntax elementDsl, ComponentAst configuration) {
        DslElementModel.Builder<T> builder = DslElementModel.builder();
        builder.withModel(model).withDsl((DslElementSyntax)configuration.getGenerationInformation().getSyntax().get()).withConfig(configuration);
        this.enrichElementModel(model, elementDsl, configuration, builder);
        return builder;
    }

    private <T extends ParameterizedModel> void enrichElementModel(T model, DslElementSyntax elementDsl, ComponentAst configuration, DslElementModel.Builder builder) {
        this.populateConnectionProviderElements(builder, configuration);
        this.populateParameterizedElements(model, elementDsl, builder, configuration, paramGroupModel -> paramModel -> configuration.getParameter(paramGroupModel.getName(), paramModel.getName()));
        this.populateComposableElements(builder, configuration);
        if (model instanceof SourceModel) {
            ((SourceModel)model).getSuccessCallback().ifPresent(cb -> this.populateParameterizedElements((ParameterizedModel)cb, elementDsl, builder, configuration, paramGroupModel -> paramModel -> configuration.getParameter(paramGroupModel.getName(), paramModel.getName())));
            ((SourceModel)model).getErrorCallback().ifPresent(cb -> this.populateParameterizedElements((ParameterizedModel)cb, elementDsl, builder, configuration, paramGroupModel -> paramModel -> configuration.getParameter(paramGroupModel.getName(), paramModel.getName())));
        }
    }

    private void populateParameterizedElements(ParameterizedModel model, DslElementSyntax elementDsl, DslElementModel.Builder builder, ComponentAst configuration, Function<ParameterGroupModel, Function<ParameterModel, ComponentParameterAst>> paramFetcher) {
        Map<String, String> parameters = configuration.getParameters().stream().filter(p -> p.getResolvedRawValue() != null).collect(Collectors.toMap(p -> p.getModel().getName(), p -> p.getResolvedRawValue(), (u, v) -> u));
        model.getParameterGroupModels().stream().filter(ParameterGroupModel::isShowInDsl).forEach(group -> this.addInlineGroup(configuration, parameters, builder, (ParameterGroupModel)group, (Function)paramFetcher.apply((ParameterGroupModel)group)));
        model.getParameterGroupModels().stream().filter(g -> !g.isShowInDsl()).forEach(g -> g.getParameterModels().forEach(p -> this.addElementParameter(configuration, parameters, elementDsl, builder, (ParameterGroupModel)g, (ParameterModel)p, paramModel -> configuration.getParameter(g.getName(), paramModel.getName()))));
    }

    private void populateConnectionProviderElements(DslElementModel.Builder builder, ComponentAst configuration) {
        configuration.directChildrenStream().filter(c -> c.getModel(ConnectionProviderModel.class).isPresent()).forEach(nestedComponentConfig -> this.create((ComponentAst)nestedComponentConfig).ifPresent(builder::containing));
    }

    private void populateComposableElements(DslElementModel.Builder builder, ComponentAst configuration) {
        configuration.directChildrenStream().filter(c -> !c.getModel(ConnectionProviderModel.class).isPresent()).forEach(nestedComponentConfig -> this.create((ComponentAst)nestedComponentConfig).ifPresent(builder::containing));
    }

    private void addInlineGroup(ComponentAst configuration, Map<String, String> parameters, DslElementModel.Builder parent, ParameterGroupModel group, Function<ParameterModel, ComponentParameterAst> paramFetcher) {
        DslElementSyntax groupSyntax = (DslElementSyntax)configuration.getGenerationInformation().getSyntax().flatMap(gs -> gs.getChild(group.getName())).get();
        Optional<ComponentIdentifier> identifier = this.getIdentifier(groupSyntax);
        if (!identifier.isPresent()) {
            return;
        }
        DslElementModel.Builder<ParameterGroupModel> groupElementBuilder = DslElementModel.builder().withModel(group).withDsl(groupSyntax);
        if (configuration.getParameters().stream().filter(param -> !param.isDefaultValue()).anyMatch(param -> param.getGroupModel().equals(group))) {
            groupElementBuilder.withGroupConfig(configuration, group);
            group.getParameterModels().forEach(p -> this.addElementParameter(configuration, parameters, groupSyntax, groupElementBuilder, group, (ParameterModel)p, paramFetcher));
            parent.containing(groupElementBuilder.build());
        } else if (this.shouldBuildDefaultGroup(group)) {
            this.buildDefaultInlineGroupElement(parent, groupElementBuilder.isExplicitInDsl(false), group, groupSyntax, identifier.get());
        }
    }

    private ComponentAst getSingleComponentConfiguration(Multimap<ComponentIdentifier, ComponentAst> innerComponents, Optional<ComponentIdentifier> identifier) {
        return identifier.filter(arg_0 -> innerComponents.containsKey(arg_0)).map(arg_0 -> innerComponents.get(arg_0)).map(collection -> (ComponentAst)collection.iterator().next()).orElse(null);
    }

    private void buildDefaultInlineGroupElement(DslElementModel.Builder parent, DslElementModel.Builder<ParameterGroupModel> groupElementBuilder, ParameterGroupModel group, DslElementSyntax groupDsl, ComponentIdentifier identifier) {
        ComponentAstBuilder groupCompAstBuilder = ComponentAstBuilder.builder();
        groupCompAstBuilder.withIdentifier(identifier);
        group.getParameterModels().forEach(paramModel -> groupDsl.getContainedElement(paramModel.getName()).ifPresent(paramDsl -> ExtensionModelUtils.getDefaultValue((ParameterModel)paramModel).ifPresent(defaultValue -> {
            DslElementModel.Builder<ParameterModel> paramElementBuilder = DslElementModel.builder().withModel((ParameterModel)paramModel).withDsl((DslElementSyntax)paramDsl).isExplicitInDsl(false).withValue((String)defaultValue);
            if (ExtensionModelUtils.isContent((ParameterModel)paramModel) || ExtensionModelUtils.isText((ParameterModel)paramModel)) {
                this.getIdentifier((DslElementSyntax)paramDsl).ifPresent(tagId -> groupCompAstBuilder.addChildComponent().withIdentifier(tagId).withBodyParameter(defaultValue).build());
            } else {
                groupCompAstBuilder.withRawParameter(defaultValue, paramDsl.getAttributeName());
            }
            groupElementBuilder.containing(paramElementBuilder.build());
        })));
        groupElementBuilder.withConfig(groupCompAstBuilder.build());
        parent.containing(groupElementBuilder.build());
    }

    private boolean shouldBuildDefaultGroup(ParameterGroupModel group) {
        return !ExtensionModelUtils.isRequired((ParameterGroupModel)group) && group.getParameterModels().stream().anyMatch(p -> ExtensionModelUtils.getDefaultValue((ParameterModel)p).isPresent());
    }

    private void addElementParameter(ComponentAst configuration, Map<String, String> parameters, final DslElementSyntax groupDsl, DslElementModel.Builder<ParameterGroupModel> groupElementBuilder, ParameterGroupModel groupModel, ParameterModel paramModel, Function<ParameterModel, ComponentParameterAst> paramFetcher) {
        Object paramComponent;
        Object paramValue;
        final DslElementSyntax paramSyntax = groupDsl.getContainedElement(paramModel.getName()).orElseGet(() -> ((DslElementSyntax)configuration.getGenerationInformation().getSyntax().get()).getContainedElement(paramModel.getName()).orElse(null));
        if (paramSyntax == null) {
            return;
        }
        ComponentParameterAst parameter = configuration.getParameter(groupModel.getName(), paramModel.getName());
        Object object = paramValue = parameter != null ? parameter.getValue().getRight() : null;
        if (parameter != null && (paramValue instanceof ComponentAst || paramValue instanceof Collection)) {
            paramComponent = paramValue instanceof Collection && ((Collection)paramValue).isEmpty() ? null : paramValue;
            if (paramSyntax.isWrapped() && paramComponent instanceof ComponentAst) {
                this.resolveWrappedElement(groupElementBuilder, paramModel, (ComponentAst)paramComponent, paramSyntax);
                return;
            }
        } else {
            paramComponent = null;
        }
        String value = paramSyntax.supportsAttributeDeclaration() ? parameters.get(paramSyntax.getAttributeName()) : (parameter != null ? parameter.getRawValue() : null);
        Optional defaultValue = ExtensionModelUtils.getDefaultValue((ParameterModel)paramModel);
        if (paramComponent != null || !StringUtils.isBlank((CharSequence)value) || defaultValue.isPresent()) {
            final DslElementModel.Builder<ParameterModel> paramElementBuilder = DslElementModel.builder().withModel(paramModel).withDsl(paramSyntax);
            if (paramComponent != null && !ExtensionModelUtils.isContent((ParameterModel)paramModel) && !ExtensionModelUtils.isText((ParameterModel)paramModel)) {
                paramModel.getType().accept(new MetadataTypeVisitor(){

                    protected void defaultVisit(MetadataType metadataType) {
                        if (paramComponent instanceof ComponentAst) {
                            ComponentAst paramComponentValue = (ComponentAst)paramComponent;
                            paramElementBuilder.withConfig(paramComponentValue);
                            ComponentAstBasedElementModelFactory.this.enrichElementModel((ParameterizedModel)paramComponentValue.getModel(ParameterizedModel.class).get(), groupDsl, paramComponentValue, paramElementBuilder);
                        }
                    }

                    public void visitArrayType(ArrayType arrayType) {
                        MetadataType itemType = arrayType.getType();
                        paramSyntax.getGeneric(itemType).ifPresent(itemdsl -> ((Collection)paramValue).stream().filter(c -> c.getModel(MetadataTypeAdapter.class).map(mtma -> mtma.isWrapperFor(itemType)).orElse(false)).forEach(c -> {
                            DslElementModel.Builder<MetadataType> arrayModelBuilder = DslElementModel.builder().withModel(itemType).withDsl((DslElementSyntax)c.getGenerationInformation().getSyntax().get()).withConfig((ComponentAst)c);
                            ComponentAstBasedElementModelFactory.this.enrichElementModel((ParameterizedModel)c.getModel(ParameterizedModel.class).get(), itemdsl, c, arrayModelBuilder);
                            paramElementBuilder.containing(arrayModelBuilder.build());
                        }));
                    }

                    public void visitObject(ObjectType objectType) {
                        if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                            ComponentAstBasedElementModelFactory.this.populateMapEntries(objectType, paramSyntax, paramElementBuilder, (Collection)paramValue);
                            return;
                        }
                        this.defaultVisit((MetadataType)objectType);
                    }
                });
            } else if (StringUtils.isBlank((CharSequence)value)) {
                Optional<String> body = paramComponent != null ? Optional.of(paramFetcher.apply(paramModel).getRawValue()) : Optional.empty();
                paramElementBuilder.withValue(body.map(String::trim).orElseGet(() -> {
                    paramElementBuilder.isExplicitInDsl(false);
                    return (String)defaultValue.get();
                }));
            } else {
                paramElementBuilder.withValue(value);
            }
            groupElementBuilder.containing(paramElementBuilder.build());
        }
    }

    protected boolean paramIsEmptyCollection(ComponentParameterAst parameter) {
        return parameter.getValue().getRight() instanceof Collection && ((Collection)parameter.getValue().getRight()).isEmpty();
    }

    private void resolveWrappedElement(DslElementModel.Builder<ParameterGroupModel> groupElementBuilder, ParameterModel p, ComponentAst paramComponent, DslElementSyntax paramSyntax) {
        if (paramComponent != null) {
            DslElementModel.Builder<ParameterModel> paramElement = DslElementModel.builder().withModel(p).withDsl(paramSyntax);
            this.create(paramComponent).ifPresent(paramElement::containing);
            groupElementBuilder.containing(paramElement.build());
        }
    }

    private Optional<ComponentIdentifier> getIdentifier(DslElementSyntax dsl) {
        if (StringUtils.isNotBlank((CharSequence)dsl.getElementName()) && StringUtils.isNotBlank((CharSequence)dsl.getPrefix())) {
            return Optional.of(ComponentIdentifier.builder().name(dsl.getElementName()).namespace(dsl.getPrefix()).build());
        }
        return Optional.empty();
    }

    private static /* synthetic */ void lambda$getNestedComponents$3(Multimap result, ComponentAst componentConfiguration) {
        result.put((Object)componentConfiguration.getIdentifier(), (Object)componentConfiguration);
    }
}

