/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.construct.DefaultFlowBuilder;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.springframework.beans.factory.FactoryBean;

public class DefaultFlowFactoryBean
extends AbstractComponent
implements FactoryBean<Flow> {
    private String name;
    private MuleContext muleContext;
    private String initialState;
    private MessageSource messageSource;
    private List<Processor> messageProcessors;
    private FlowExceptionHandler exceptionListener;
    private ProcessingStrategyFactory processingStrategyFactory;
    private Integer maxConcurrency;
    private FeatureFlaggingService featureFlaggingService;

    public Flow getObject() throws Exception {
        Flow.Builder flowBuilder = Flow.builder((String)this.name, (MuleContext)this.muleContext).messagingExceptionHandler(this.exceptionListener).initialState(this.initialState);
        flowBuilder.processors(this.messageProcessors != null ? this.messageProcessors : Collections.emptyList());
        if (this.messageSource != null) {
            flowBuilder.source(this.messageSource);
        }
        if (this.processingStrategyFactory != null) {
            flowBuilder.processingStrategyFactory(this.processingStrategyFactory);
        }
        if (this.maxConcurrency != null) {
            flowBuilder.maxConcurrency(this.maxConcurrency.intValue());
        }
        DefaultFlowBuilder.DefaultFlow flow = (DefaultFlowBuilder.DefaultFlow)flowBuilder.build();
        flow.setAnnotations(this.getAnnotations());
        flow.setFeatureFlaggingService(this.featureFlaggingService);
        return flow;
    }

    public Class<Flow> getObjectType() {
        return Flow.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
        try {
            this.featureFlaggingService = (FeatureFlaggingService)((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(FeatureFlaggingService.class);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public String getInitialState() {
        return this.initialState;
    }

    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public List<Processor> getMessageProcessors() {
        return this.messageProcessors;
    }

    public void setMessageProcessors(List<Processor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public FlowExceptionHandler getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(FlowExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public ProcessingStrategyFactory getProcessingStrategyFactory() {
        return this.processingStrategyFactory;
    }

    public void setProcessingStrategyFactory(ProcessingStrategyFactory processingStrategyFactory) {
        this.processingStrategyFactory = processingStrategyFactory;
    }

    public void setMaxConcurrency(Integer maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }
}

