/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.config.internal.BeanDependencyResolver;
import org.mule.runtime.config.internal.ComponentModelInitializer;
import org.mule.runtime.config.internal.LazyComponentInitializerAdapter;
import org.mule.runtime.config.internal.LazyConnectivityTestingService;
import org.mule.runtime.config.internal.LazyMetadataService;
import org.mule.runtime.config.internal.LazyValueProviderService;
import org.mule.runtime.config.internal.MuleArtifactContext;
import org.mule.runtime.config.internal.OptionalObjectsController;
import org.mule.runtime.config.internal.SpringConfigurationComponentLocator;
import org.mule.runtime.config.internal.dsl.model.ConfigurationDependencyResolver;
import org.mule.runtime.config.internal.dsl.model.MinimalApplicationModelGenerator;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigResource;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.transaction.TransactionManagerFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.connectivity.DefaultConnectivityTestingService;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.core.internal.security.DefaultMuleSecurityManager;
import org.mule.runtime.core.internal.store.SharedPartitionedPersistentObjectStore;
import org.mule.runtime.core.internal.value.MuleValueProviderService;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class LazyMuleArtifactContext
extends MuleArtifactContext
implements LazyComponentInitializerAdapter,
ComponentModelInitializer {
    public static final String SHARED_PARTITIONED_PERSISTENT_OBJECT_STORE_PATH = "_sharedPartitionatedPersistentObjectStorePath";
    private static final Logger LOGGER = LoggerFactory.getLogger(LazyMuleArtifactContext.class);
    private List<String> beansCreated = new ArrayList<String>();
    private Optional<ComponentModelInitializer> parentComponentModelInitializer;
    private ConfigurationDependencyResolver dependencyResolver;

    public LazyMuleArtifactContext(MuleContext muleContext, ConfigResource[] artifactConfigResources, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController, Map<String, String> artifactProperties, ArtifactType artifactType, List<ClassLoader> pluginsClassLoaders, Optional<ComponentModelInitializer> parentComponentModelInitializer, Optional<ConfigurationProperties> parentConfigurationProperties, boolean disableXmlValidations, ComponentBuildingDefinitionProvider runtimeComponentBuildingDefinitionProvider) throws BeansException {
        super(muleContext, artifactConfigResources, artifactDeclaration, optionalObjectsController, LazyMuleArtifactContext.extendArtifactProperties(artifactProperties), artifactType, pluginsClassLoaders, parentConfigurationProperties, disableXmlValidations, runtimeComponentBuildingDefinitionProvider);
        this.componentLocator = new SpringConfigurationComponentLocator();
        this.applicationModel.executeOnEveryMuleComponentTree(componentModel -> componentModel.setEnabled(false));
        this.enableMuleObjects();
        this.parentComponentModelInitializer = parentComponentModelInitializer;
        this.dependencyResolver = new ConfigurationDependencyResolver(this.applicationModel, this.componentBuildingDefinitionRegistry);
        muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleConnectivityTestingService", (Object)new LazyConnectivityTestingService(this, () -> (ConnectivityTestingService)this.getRegistry().lookupByName("_muleNonLazyConnectivityTestingService").get()));
        muleContext.getCustomizationService().registerCustomServiceClass("_muleNonLazyConnectivityTestingService", DefaultConnectivityTestingService.class);
        muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleMetadataService", (Object)new LazyMetadataService(this, () -> (MetadataService)this.getRegistry().lookupByName("_muleNonLazyMetadataService").get()));
        muleContext.getCustomizationService().registerCustomServiceClass("_muleNonLazyMetadataService", MuleMetadataService.class);
        muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleValueProviderService", (Object)new LazyValueProviderService(this, () -> (ValueProviderService)this.getRegistry().lookupByName("_muleNonLazyValueProviderService").get(), () -> ((MuleContext)muleContext).getConfigurationComponentLocator()));
        muleContext.getCustomizationService().registerCustomServiceClass("_muleNonLazyValueProviderService", MuleValueProviderService.class);
        muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleLazyComponentInitializer", (Object)this);
        String sharedPartitionatedPersistentObjectStorePath = artifactProperties.get(SHARED_PARTITIONED_PERSISTENT_OBJECT_STORE_PATH);
        if (sharedPartitionatedPersistentObjectStorePath != null) {
            muleContext.getCustomizationService().overrideDefaultServiceImpl("_defaultPersistentObjectStore", (Object)new SharedPartitionedPersistentObjectStore(new File(sharedPartitionatedPersistentObjectStorePath)));
        }
    }

    private void enableMuleObjects() {
        ConfigurationDependencyResolver dependencyResolver = new ConfigurationDependencyResolver(this.applicationModel, this.componentBuildingDefinitionRegistry);
        new MinimalApplicationModelGenerator(dependencyResolver, true).getMinimalModel(componentModel -> {
            final AtomicBoolean transactionFactoryType = new AtomicBoolean(false);
            TypeDefinitionVisitor visitor = new TypeDefinitionVisitor(){

                public void onType(Class<?> type) {
                    transactionFactoryType.set(TransactionManagerFactory.class.isAssignableFrom(type));
                }

                public void onConfigurationAttribute(String attributeName, Class<?> enforcedClass) {
                }

                public void onMapType(TypeDefinition.MapEntryType mapEntryType) {
                }
            };
            return this.componentBuildingDefinitionRegistry.getBuildingDefinition(componentModel.getIdentifier()).map(componentBuildingDefinition -> {
                componentBuildingDefinition.getTypeDefinition().visit(visitor);
                return transactionFactoryType.get();
            }).orElse(false);
        });
    }

    private static Map<String, String> extendArtifactProperties(Map<String, String> artifactProperties) {
        HashMap<String, String> extendedArtifactProperties = new HashMap<String, String>(artifactProperties);
        extendedArtifactProperties.put("mule.application.deployment.lazyInit", "true");
        return extendedArtifactProperties;
    }

    private void applyLifecycle(List<Object> components, boolean applyStartPhase) {
        this.muleContext.withLifecycleLock(() -> {
            if (this.muleContext.isInitialised()) {
                for (Object object : components) {
                    try {
                        if (object instanceof MessageProcessorChain) {
                            LifecycleUtils.initialiseIfNeeded(object, (MuleContext)this.muleContext);
                            continue;
                        }
                        this.muleContext.getRegistry().applyLifecycle(object, "initialise");
                    }
                    catch (MuleException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (applyStartPhase && this.muleContext.isStarted()) {
                for (Object object : components) {
                    try {
                        if (object instanceof MessageProcessorChain) {
                            LifecycleUtils.startIfNeeded(object);
                            continue;
                        }
                        this.muleContext.getRegistry().applyLifecycle(object, "initialise", "start");
                    }
                    catch (MuleException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    private static BeanDependencyResolver getBeanDependencyResolver(ConfigurationDependencyResolver configurationDependencyResolver, Map<String, Object> components) {
        return beanNames -> beanNames.stream().flatMap(name -> configurationDependencyResolver.resolveComponentDependencies((String)name).stream()).map(componentName -> components.get(componentName)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void initializeComponent(Location location) {
        this.initializeComponent(location, true);
    }

    @Override
    public void initializeComponents(LazyComponentInitializer.ComponentLocationFilter filter) {
        this.initializeComponents(filter, true);
    }

    @Override
    public void initializeComponent(Location location, boolean applyStartPhase) {
        this.applyLifecycle(this.createComponents(Optional.empty(), Optional.of(location), this.getParentComponentModelInitializerAdapter(applyStartPhase)), applyStartPhase);
    }

    @Override
    public void initializeComponents(LazyComponentInitializer.ComponentLocationFilter filter, boolean applyStartPhase) {
        this.applyLifecycle(this.createComponents(Optional.of(o -> {
            ComponentModel componentModel = (ComponentModel)o;
            if (componentModel.getComponentLocation() != null) {
                return filter.accept((ComponentLocation)componentModel.getComponentLocation());
            }
            return false;
        }), Optional.empty(), this.getParentComponentModelInitializerAdapter(applyStartPhase)), applyStartPhase);
    }

    @Override
    public void initializeComponents(Predicate<ComponentModel> componentModelPredicate, boolean applyStartPhase) {
        this.applyLifecycle(this.createComponents(Optional.of(componentModelPredicate), Optional.empty(), this.getParentComponentModelInitializerAdapter(applyStartPhase)), applyStartPhase);
    }

    public Optional<ComponentModelInitializerAdapter> getParentComponentModelInitializerAdapter(boolean applyStartPhase) {
        return this.parentComponentModelInitializer.map(componentModelInitializer -> componentModelPredicate -> componentModelInitializer.initializeComponents(componentModelPredicate, applyStartPhase));
    }

    private List<Object> createComponents(Optional<Predicate> predicateOptional, Optional<Location> locationOptional, Optional<ComponentModelInitializerAdapter> parentComponentModelInitializerAdapter) {
        Preconditions.checkState((predicateOptional.isPresent() != locationOptional.isPresent() ? 1 : 0) != 0, (String)"predicate or location has to be passed");
        return (List)ClassUtils.withContextClassLoader((ClassLoader)this.muleContext.getExecutionClassLoader(), () -> {
            this.unregisterBeans(this.beansCreated);
            this.beansCreated.clear();
            this.objectProviders.clear();
            this.resetMuleSecurityManager();
            this.applicationModel.executeOnEveryMuleComponentTree(componentModel -> componentModel.setEnabled(false));
            MinimalApplicationModelGenerator minimalApplicationModelGenerator = new MinimalApplicationModelGenerator(this.dependencyResolver);
            this.resetMuleConfiguration(minimalApplicationModelGenerator);
            Reference minimalApplicationModel = new Reference();
            predicateOptional.ifPresent(predicate -> {
                ApplicationModel cfr_ignored_0 = (ApplicationModel)minimalApplicationModel.set((Object)minimalApplicationModelGenerator.getMinimalModel((Predicate<ComponentModel>)predicate));
            });
            locationOptional.ifPresent(location -> {
                ApplicationModel cfr_ignored_0 = (ApplicationModel)minimalApplicationModel.set((Object)minimalApplicationModelGenerator.getMinimalModel((Location)location));
            });
            if (parentComponentModelInitializerAdapter.isPresent()) {
                List missingComponentNames = this.dependencyResolver.getMissingDependencies().stream().filter(dependencyNode -> dependencyNode.isTopLevel()).map(dependencyNode -> dependencyNode.getComponentName()).collect(Collectors.toList());
                ((ComponentModelInitializerAdapter)parentComponentModelInitializerAdapter.get()).initializeComponents((ComponentModel componentModel) -> {
                    if (componentModel.getNameAttribute() != null) {
                        return missingComponentNames.contains(componentModel.getNameAttribute());
                    }
                    return false;
                });
            } else {
                this.dependencyResolver.getMissingDependencies().stream().forEach(globalElementName -> {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("Ignoring dependency %s because it does not exists", globalElementName));
                    }
                });
            }
            List<String> applicationComponents = this.createApplicationComponents((DefaultListableBeanFactory)this.getBeanFactory(), (ApplicationModel)minimalApplicationModel.get(), false);
            super.prepareObjectProviders();
            List<Object> sortedObjects = this.createBeans(applicationComponents);
            return sortedObjects;
        });
    }

    private List<Object> createBeans(List<String> applicationComponentNames) {
        LinkedHashMap<String, Object> objects = new LinkedHashMap<String, Object>();
        applicationComponentNames.forEach(componentName -> {
            Object object = this.getRegistry().lookupByName(componentName).orElse(null);
            if (object != null) {
                if (object instanceof MessageProcessorChainBuilder) {
                    String chainKey = componentName + "@" + object.hashCode();
                    MessageProcessorChain messageProcessorChain = ((MessageProcessorChainBuilder)object).build();
                    try {
                        this.getMuleContext().getRegistry().registerObject(chainKey, (Object)messageProcessorChain);
                    }
                    catch (RegistrationException e) {
                        this.unregisterBeans((List<String>)ImmutableList.copyOf(objects.keySet()));
                        throw new IllegalStateException("Couldn't register an instance of a MessageProcessorChain", e);
                    }
                    objects.put(chainKey, messageProcessorChain);
                }
                objects.put((String)componentName, object);
            }
        });
        ComponentConfigurationLifecycleObjectSorter componentConfigurationLifecycleObjectSorter = new ComponentConfigurationLifecycleObjectSorter(LazyMuleArtifactContext.getBeanDependencyResolver(this.getDependencyResolver(), objects));
        HashMap componentNames = new HashMap();
        objects.entrySet().forEach(entry -> {
            Object object = entry.getValue();
            String componentName = (String)entry.getKey();
            componentConfigurationLifecycleObjectSorter.addObject(componentName, object);
            componentNames.put(object, componentName);
        });
        List<Object> sortedObjects = componentConfigurationLifecycleObjectSorter.getSortedObjects();
        sortedObjects.forEach(object -> this.beansCreated.add((String)componentNames.get(object)));
        return sortedObjects;
    }

    private void resetMuleSecurityManager() {
        boolean registerMuleSecurityManager;
        block5: {
            registerMuleSecurityManager = false;
            try {
                this.muleContext.getRegistry().unregisterObject("_muleSecurityManager");
                registerMuleSecurityManager = true;
            }
            catch (Exception e) {
                if (ExceptionUtils.hasCause((Throwable)e, NoSuchBeanDefinitionException.class)) break block5;
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error while unregistering Mule security manager"), (Throwable)e);
            }
        }
        if (registerMuleSecurityManager) {
            try {
                this.muleContext.getRegistry().registerObject("_muleSecurityManager", (Object)new DefaultMuleSecurityManager());
            }
            catch (RegistrationException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Couldn't register a new instance of Mule security manager in the registry"), (Throwable)e);
            }
        }
    }

    private void resetMuleConfiguration(MinimalApplicationModelGenerator minimalApplicationModelGenerator) {
        block2: {
            try {
                this.muleContext.getRegistry().unregisterObject("_muleConfiguration");
            }
            catch (Exception e) {
                if (ExceptionUtils.hasCause((Throwable)e, NoSuchBeanDefinitionException.class)) break block2;
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error while unregistering Mule configuration"), (Throwable)e);
            }
        }
        minimalApplicationModelGenerator.getMinimalModel(componentModel -> componentModel.getIdentifier().equals(CoreDslConstants.CONFIGURATION_IDENTIFIER));
    }

    @Override
    protected void prepareObjectProviders() {
    }

    @Override
    public void close() {
        this.beansCreated.clear();
        super.close();
    }

    private void unregisterBeans(List<String> beans) {
        this.doUnregisterBeans(beans.stream().collect(Collectors.toCollection(LinkedList::new)).descendingIterator());
        this.componentLocator.removeComponents();
    }

    private void doUnregisterBeans(Iterator<String> beanNames) {
        while (beanNames.hasNext()) {
            String beanName = beanNames.next();
            try {
                LegacyRegistryUtils.unregisterObject((MuleContext)this.muleContext, (String)beanName);
            }
            catch (Exception e) {
                this.logger.warn((Object)String.format("Exception unregistering an object during lazy initialization of component %s, exception message is %s", beanName, e.getMessage()));
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @FunctionalInterface
    private static interface ComponentModelInitializerAdapter {
        public void initializeComponents(Predicate<ComponentModel> var1);
    }

    class ComponentConfigurationLifecycleObjectSorter {
        private final BeanDependencyResolver beanDependencyResolver;
        private List<Object> sortedObjects = new ArrayList<Object>();

        public ComponentConfigurationLifecycleObjectSorter(BeanDependencyResolver beanDependencyResolver) {
            this.beanDependencyResolver = beanDependencyResolver;
        }

        public int addObject(String name, Object object) {
            if (this.sortedObjects.contains(object)) {
                return 0;
            }
            List dependencies = this.beanDependencyResolver.resolveBeanDependencies((Set<String>)ImmutableSet.of((Object)name)).stream().filter(dependency -> !this.sortedObjects.contains(dependency)).collect(Collectors.toList());
            this.sortedObjects.addAll(dependencies);
            this.sortedObjects.add(object);
            return dependencies.size() + 1;
        }

        public List<Object> getSortedObjects() {
            return this.sortedObjects;
        }
    }
}

