/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import com.google.common.base.Throwables;
import java.util.List;
import java.util.function.Supplier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.exception.ObjectNotFoundException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.config.internal.dsl.model.NoSuchComponentModelException;

public class LazyConnectivityTestingService
implements ConnectivityTestingService,
Initialisable {
    public static final String NON_LAZY_CONNECTIVITY_TESTING_SERVICE = "_muleNonLazyConnectivityTestingService";
    private final LazyComponentInitializer lazyComponentInitializer;
    private final Supplier<ConnectivityTestingService> connectivityTestingServiceSupplier;
    private ConnectivityTestingService connectivityTestingService;

    public LazyConnectivityTestingService(LazyComponentInitializer lazyComponentInitializer, Supplier<ConnectivityTestingService> connectivityTestingServiceSupplier) {
        this.lazyComponentInitializer = lazyComponentInitializer;
        this.connectivityTestingServiceSupplier = connectivityTestingServiceSupplier;
    }

    public ConnectionValidationResult testConnection(Location location) {
        try {
            this.lazyComponentInitializer.initializeComponent(location);
        }
        catch (MuleRuntimeException e) {
            if (e.getCause() instanceof NoSuchComponentModelException) {
                throw new ObjectNotFoundException(location.toString());
            }
            List causalChain = Throwables.getCausalChain((Throwable)e);
            return this.unknownFailureResponse(this.lastMessage(causalChain), (Exception)((Object)e));
        }
        catch (Exception e) {
            return this.unknownFailureResponse(e.getCause().getMessage(), e);
        }
        return this.connectivityTestingService.testConnection(location);
    }

    private ConnectionValidationResult unknownFailureResponse(String message, Exception e) {
        return ConnectionValidationResult.failure((String)message, (Exception)e);
    }

    private String lastMessage(List<Throwable> causalChain) {
        return causalChain.get(causalChain.size() - 1).getMessage();
    }

    public void initialise() throws InitialisationException {
        this.connectivityTestingService = this.connectivityTestingServiceSupplier.get();
    }
}

